const BaseClient = require("./baseClient")
const settings = require("../../../config/settings");
const system = require("../../system");
const { appKey, secret } = settings;
/**
 * 工商 产品
 */
class GongshangClient extends BaseClient {
    constructor() {
        super(appKey, secret, "/web/action/regapi/springBoard");
        this.instance = null;
        this.CIRCUITSTATUS = {
            RECEIVED: 701,//已接单
            COLLECTING: 702,//材料收集环节
            AUDITING: 703,//工商审核环节
            ENGRAVING: 704,//刻章环节
            SUCCESS: 705,//已完成
        }
    }

    static getInstance() {
        if (!this.instance) {
            this.instance = new GongshangClient();
        }
        return this.instance;
    }

    async submitMaterials(username, deliverData, materials) {
        const { companyInfo, materialFile, } = materials;
        let { applicationFormUrl, registDocumentsUrl } = materialFile;
        let { companyName, spareName, companyProperties, fullAddress, engagedIndustry,
            businessScope, operatingPeriod, addressType, taxpayerType, serviceArea } = companyInfo;
        // if (serviceArea.length == 2) {
        //     if (serviceArea[1] === "市辖区") {
        //         serviceArea = serviceArea[0];
        //     } else {
        //         serviceArea = serviceArea[1];
        //     }
        // } else {
        //     serviceArea = undefined;
        // }
        let status;
        switch (deliverData.delivery_status) {
            case system.SERVERSESTATUS.COLLECTING: // 工商审核环节
                status = this.CIRCUITSTATUS.AUDITING;
                break
            case system.SERVERSESTATUS.AUDITING: // 工商审核环节
                status = this.CIRCUITSTATUS.AUDITING;
                break
            case system.SERVERSESTATUS.ENGRAVING: // 刻章环节
                status = this.CIRCUITSTATUS.ENGRAVING;
                break
            case system.SERVERSESTATUS.SUCCESS: // 服务中
                status = system.SERVERSESTATUS.SUCCESS;
                break
            default:
                throw new Error("此状态手动不能更改");
        }
        await this.pushQiFuTong(username, {
            actionType: "regUpdateOrderStatus",
            actionBody: {
                orderNo: deliverData.delivery_code,
                status,
                deliverContent: {
                    applicationFormUrl: applicationFormUrl.url,
                    registDocumentsUrl: registDocumentsUrl.url,
                    baseInfo: {},
                    companyInfo: {
                        companyName,
                        spareName: spareName.filter(item => {
                            return item;
                        }),
                        companyProperties,
                        addressType,
                        fullAddress,
                        taxpayerType,
                        serviceArea,
                        engagedIndustry,
                        businessScope,
                        operatingPeriod
                    }
                },

            }
        });
    }

    async changeStatus(username, deliverData, materials = {}) {
        let status;
        switch (deliverData.delivery_status) {
            case system.SERVERSESTATUS.RECEIVED:
                if (deliverData.product_code === system.SERVICECODE.COMPANYCASE) {
                    status = this.CIRCUITSTATUS.COLLECTING;
                } else {
                    status = "TODO:";
                }
                break
            case system.SERVERSESTATUS.AUDITING: // 工商审核环节
                status = this.CIRCUITSTATUS.ENGRAVING;
                break
            case system.SERVERSESTATUS.ENGRAVING: // 刻章环节
                status = this.CIRCUITSTATUS.SUCCESS;
                break
            case system.SERVERSESTATUS.SERVICEING: // 服务中
                status = system.SERVERSESTATUS.SUCCESS;
                break
            default:
                throw new Error("此状态手动不能更改");
        }
        await this.pushQiFuTong(username, {
            actionType: "regUpdateOrderStatus",
            actionBody: {
                orderNo: deliverData.delivery_code,
                status,
            }
        });
    }
}

module.exports = GongshangClient