const system = require("../../../system");
const Dao = require("../../dao.base");
const url = require("url");
class DeliverDao extends Dao {
  constructor() {
    super(Dao.getModelName(DeliverDao));
  }
  orderBy() {
    return [["updated_at", "DESC"]];
  }
  extraWhere(qobj, qw, qc) {

    // 权限添加 
    //需要添加公司查询条件
    qc.where["facilitator_id"] = Number(qobj.company_id || -1);
    // 组织结构
    if (qobj.opath && qobj.opath != "") {
      qc.where['$or'] = [
        {
          delivery_man_opcode: { [this.db.Op.like]: `%${qobj.opath}%` },
        },
        {
          salesman_opcode: { [this.db.Op.like]: `%${qobj.opath}%` },
        }
      ]
    }

    qc.raw = true;
    let type = qobj.bizpath.split('/')[1];

    if (type === 'deliveryManagement') {
      qc.where.product_code = qc.where.product_code && [system.SERVICECODE.EDI, system.SERVICECODE.ICP].includes(qc.where.product_code) ? qc.where.product_code : {
        $in: [system.SERVICECODE.EDI, system.SERVICECODE.ICP]
      }

      switch (qobj.bizpath) {
        case "/deliveryManagement/wait":
          qc.where.delivery_status = qc.where.delivery_status || {
            $notIn: [system.SERVERSESTATUS.SUCCESS, system.SERVERSESTATUS.CLOSED]
          }
          break
        case "/deliveryManagement/deliveryAllocated":
          qc.where.delivery_man_opcode = {
            $and: [{ $not: null }, { $not: "" }]
          }
          break
        case "/deliveryManagement/deliveryNoAllocate":
          delete qc.where['$or'];
          qc.where.delivery_man_opcode = {
            $or: [{ $eq: null }, { $eq: "" }]
          }
          break
        case "/deliveryManagement/all":
          break
      }
    } else if (type === "annualReport") {
      qc.where.product_code = qc.where.product_code && [system.SERVICECODE.ICPANNUALREPORT, system.SERVICECODE.EDIANNUALREPORT].includes(qc.where.product_code) ? qc.where.product_code : {
        $in: [system.SERVICECODE.EDIANNUALREPORT, system.SERVICECODE.ICPANNUALREPORT]
      }

      // ---- 兼容 年报 状态 未申报、已申报 start
      let status;
      if ([system.ANNUALREPORT.WAITDECLARE, system.ANNUALREPORT.DECLARESUCCESS].includes(qc.where.delivery_status)) {
        status = qc.where.delivery_status;
        delete qc.where.delivery_status;
        qobj.bizpath = "/annualReport/wait";

      }
      let include = {
        model: this.db.models.annualreport,
        attributes: ['status', "year"],
        where: {
          year: {
            $or: [
              new Date().getFullYear(),
              null
            ]
          },
        },
        required: false
      }
      if (status) {
        include.where.status = status;
        delete include.required;
      }

      qc.include = [
        include
      ]
      // ---- 兼容 年报 状态 未申报、已申报 end

      switch (qobj.bizpath) {
        case "/annualReport/wait":
          qc.where.delivery_status = qc.where.delivery_status || {
            $in: [system.ANNUALREPORT.TAKEEFFECT]
          }
          break
        case "/annualReport/all":
          qc.where.delivery_status = qc.where.delivery_status || {
            $in: [system.ANNUALREPORT.TAKEEFFECT, system.ANNUALREPORT.SUCCESS]
          }
          break
      }

    } else if (type === "wangwenManagement") {
      let filters = [];
      filters.push({
        product_code: "wangwen"
      })
      switch (qobj.bizpath) {
        case "/wangwenManagement/wait":
          filters.push({
            delivery_status: {
              $notIn: [system.SERVERSESTATUS.SUCCESS, system.SERVERSESTATUS.CLOSED]
            }
          });
          break
        case "/wangwenManagement/deliveryAllocated":
          filters.push({
            delivery_man_opcode: {
              $ne: null
            }
          });
          break
        case "/wangwenManagement/deliveryNoAllocate":
          delete qc.where['$or'];
          filters.push({
            delivery_man_opcode: {
              $eq: null
            }
          });
          break
        case "/wangwenManagement/all":
          break
      }
      qc.where["$and"] = filters;
    } else if (type === "foodManagement") {
      let filters = [];
      filters.push({
        product_code: "food"
      })
      switch (qobj.bizpath) {
        case "/foodManagement/wait":
          filters.push({
            delivery_status: {
              $notIn: [system.SERVERSESTATUS.SUCCESS, system.SERVERSESTATUS.CLOSED]
            }
          });
          break
        case "/foodManagement/deliveryAllocated":
          filters.push({
            delivery_man_opcode: {
              $ne: null
            }
          });
          break
        case "/foodManagement/deliveryNoAllocate":
          delete qc.where['$or'];
          filters.push({
            delivery_man_opcode: {
              $eq: null
            }
          });
          break
        case "/foodManagement/all":
          break
      }
      qc.where["$and"] = filters;
    } else if (type === "guangboManagement") {
      let filters = [];
      filters.push({
        product_code: "guangbo"
      })
      switch (qobj.bizpath) {
        case "/guangboManagement/wait":
          filters.push({
            delivery_status: {
              $notIn: [system.SERVERSESTATUS.SUCCESS, system.SERVERSESTATUS.CLOSED]
            }
          });
          break
        case "/guangboManagement/deliveryAllocated":
          filters.push({
            delivery_man_opcode: {
              $ne: null
            }
          });
          break
        case "/guangboManagement/deliveryNoAllocate":
          delete qc.where['$or'];
          filters.push({
            delivery_man_opcode: {
              $eq: null
            }
          });
          break
        case "/guangboManagement/all":
          break
      }
      qc.where["$and"] = filters;
    } else if (type === "companyManagement") {
      let filters = [];
      filters.push({
        product_code: {
          $in: [
            system.SERVICECODE.COMPANYCASE,
            // system.SERVICECODE.SEALSEVCASE,
            // system.SERVICECODE.TAXCONTROLCASE,
            // system.SERVICECODE.TAXCASE,
            // system.SERVICECODE.ICCHANGECASE
          ]
        }
      })
      switch (qobj.bizpath) {
        case "/companyManagement/deliveryAllocated":
          filters.push({
            delivery_man_opcode: {
              $ne: null
            }
          });
          break
        case "/companyManagement/deliveryNoAllocate":
          delete qc.where['$or'];
          filters.push({
            delivery_man_opcode: {
              $eq: null
            }
          });
          break
        case "/companyManagement/wait":
          filters.push({
            delivery_status: {
              $notIn: [system.SERVERSESTATUS.SUCCESS, system.SERVERSESTATUS.CLOSED]
            }
          });
          break
        case "/companyManagement/all":
          break
      }
      qc.where["$and"] = filters;
    } else {
      throw new Error("页面路径错误")
    }
    return qw;
  }

  async findInfo(pobj) {
    const result = await this.model.findOne({
      where: {
        id: pobj.id
      },
      include: [
        {
          model: this.db.models.qualification,
          // attributes: ['id', 'certificateNumber', 'businessTypes', 'businessScope', 'serviceProject', 'startAt', 'endAt', 'file'],
          raw: false
        }, {
          model: this.db.models.material,
          raw: false
        }
      ],
      raw: false
    });
    return result;
  }
  async findAnnualReportInfo(pobj) {
    const result = await this.model.findOne({
      where: {
        id: pobj.id
      },
      include: [
        {
          model: this.db.models.annualreport,
          // attributes: ['id', 'certificateNumber', 'businessTypes', 'businessScope', 'serviceProject', 'startAt', 'endAt', 'file'],
        }
      ],
      raw: false
    });
    return result;
  }

  async newFindInfo(pobj) {
    const result = await this.model.findOne({
      where: {
        id: pobj.id
      },
      include: [
        {
          model: this.db.models.newmaterial,
          raw: false
        }
      ],
      raw: false
    });
    return result;
  }
}
module.exports = DeliverDao;
