const system = require("../system");
var moment = require('moment');
const settings = require("../../config/settings");
const uuidv4 = require('uuid/v4');
class ServiceBase {
  constructor(gname, daoName) {
    //this.dbf=system.getObject("db.connection");
    this.db = system.getObject("db.common.connection").getCon();
    this.cacheManager = system.getObject("db.common.cacheManager");
    console.log(">>>>>>>>>>>>>>..", daoName)
    this.daoName = daoName;
    this.dao = system.getObject("db." + gname + "." + daoName);
    this.restS = system.getObject("util.restClient");
    this.md5 = require("MD5");
  }
  getEncryptStr(str) {
    if (!str) {
      throw new Error("字符串不能为空");
    }
    var md5 = this.md5(str + "_" + settings.salt);
    return md5.toString().toLowerCase();
  }
  getUUID() {
    var uuid = uuidv4();
    var u = uuid.replace(/\-/g, "");
    return u;
  }
  static getDaoName(ClassObj) {
    console.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>..");
    let rtnstr = ClassObj["name"].substring(0, ClassObj["name"].lastIndexOf("Service")).toLowerCase() + "Dao";
    console.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>..", rtnstr);
    return rtnstr;
  }
  async findAndCountAll(obj) {
    const apps = await this.dao.findAndCountAll(obj);
    return apps;
  }
  async refQuery(pobj) {
    return this.dao.refQuery(pobj);
  }
  async bulkDelete(ids) {
    var en = await this.dao.bulkDelete(ids);
    return en;
  }
  async delete(qobj) {
    return this.dao.delete(qobj);
  }
  async create(qobj) {
    return this.dao.create(qobj);
  }
  async update(qobj, tm = null) {
    return this.dao.update(qobj, tm);
  }
  async updateByWhere(setObj, whereObj, t) {
    return this.dao.updateByWhere(setObj, whereObj, t);
  }
  async customExecAddOrPutSql(sql, paras = null) {
    return this.dao.customExecAddOrPutSql(sql, paras);
  }
  async customQuery(sql, paras, t) {
    return this.dao.customQuery(sql, paras, t);
  }
  async findCount(whereObj = null) {
    return this.dao.findCount(whereObj);
  }
  async findSum(fieldName, whereObj = null) {
    return this.dao.findSum(fieldName, whereObj);
  }
  async getPageList(pageIndex, pageSize, whereObj = null, orderObj = null, attributesObj = null, includeObj = null) {
    return this.dao.getPageList(pageIndex, pageSize, whereObj, orderObj, attributesObj, includeObj);
  }
  async findOne(obj, attributes = []) {
    return this.dao.findOne(obj, attributes);
  }
  async findById(oid) {
    return this.dao.findById(oid);
  }
  async findAll(obj, include = []) {
    return this.dao.findAll(obj, include);
  }
  /*
  返回20位业务订单号
  prefix：业务前缀
  */
  async getBusUid(prefix) {
    prefix = (prefix || "");
    if (prefix) {
      prefix = prefix.toUpperCase();
    }
    var prefixlength = prefix.length;
    var subLen = 8 - prefixlength;
    var uidStr = "";
    if (subLen > 0) {
      uidStr = await this.getUidInfo(subLen, 60);
    }
    var timStr = moment().format("YYYYMMDDHHmm");
    return prefix + timStr + uidStr;
  }
  async getBusUid2(prefix) {
    prefix = (prefix || "");
    if (prefix) {
      prefix = prefix.toUpperCase();
    }
    var prefixlength = prefix.length;
    var subLen = 20 - prefixlength;
    var uidStr = "";
    if (subLen > 0) {
      uidStr = await this.getUidInfo(subLen, 60);
    }
    return prefix + uidStr;
  }
  /*
  len：返回长度
  radix：参与计算的长度，最大为62
  */
  async getUidInfo(len, radix) {
    var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
    var uuid = [], i;
    radix = radix || chars.length;
    if (len) {
      for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
      var r;
      uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
      uuid[14] = '4';
      for (i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | Math.random() * 16;
          uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    return uuid.join('');
  }
  //kong统一处理
  //统一注册组件
  async cformregister(opurl, opts) {
    try {
      let rtn = await system.post3wFormTypeReq(opurl, opts)
      console.log(rtn);
      if (rtn.statusCode == 409) {
        //return new Error("已经存在相同的统一账号名称!");
        return null;
      }
      if (rtn.statusCode == 201) {
        return rtn.data;
      } else {
        throw new Error(rtn.data);
      }
    } catch (e) {
      console.log(e);
      return null;
    }
  }
  async cget(opurl) {
    let rtn = await system.getReq(opurl)
    return rtn;
  }
  async cjsonregister(opurl, opts) {
    try {
      let rtn = await system.postJsonTypeReq(opurl, opts)
      console.log(",,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,", rtn);
      if (rtn.statusCode == 409) {
        //return new Error("已经存在相同的统一账号名称!");
        return null;
      }
      if (rtn.statusCode == 201) {
        return rtn.data;
      } else {
        throw new Error(rtn.data);
      }
      return null;
    } catch (e) {
      console.log(e);
      return null;
    }
  }
  async cdel(opurl) {
    try {
      let rtn = await system.delReq(opurl)
      if (rtn.statusCode == 204) {
        return {};
      } else {
        throw new Error(rtn.data);
      }
    } catch (e) {
      console.log(e);
      return null;
    }
  }
  static bindPluginUrl(rname) {
    return settings.kongurl() + "routes/" + rname + "/plugins";
  }
  static newRouteUrl(sname) {
    return settings.kongurl() + "services/" + sname + "/routes";
  }
  static newServiceUrl() {
    return settings.kongurl() + "services";
  }
  static newConsumerUrl() {
    return settings.kongurl() + "consumers";
  }
  static newJwtCredUrl(consumername) {
    return settings.kongurl() + "consumers/" + consumername + "/jwt";
  }
  static serviceUrl(sname) {
    return settings.kongurl() + "services/" + sname;
  }
  static routeUrl(rname) {
    return settings.kongurl() + "routes/" + rname;
  }
  static consumerUrl(consumerName) {
    return settings.kongurl() + "consumers/" + consumerName;
  }
}
module.exports = ServiceBase;
