const system = require("../../../system");
const settings = require("../../../../config/settings");
const fqBaseUrl="https://fq.gongsibao.com";//生产环境
// const fqBaseUrl="https://fqdev.gongsibao.com";//测试环境
class FqUtilsService {
    constructor() {
        this.execClient = system.getObject("util.execClient");
        this.logClient = system.getObject("util.logClient");
    }
    /**
     * 推送投放落地页需求至蜂擎
     * @param {*} pobj 
     * @param {*} code 
     */
    async pushNeedInfo2Fq(pobj,code){
        try {
            var url = fqBaseUrl+"/open/ex/flux/advisory?code="+code;
            var rtn = await this.execClient.execPost(pobj, url);
            var data = JSON.parse(rtn.stdout);
            this.logClient.pushlog("推送投放落地页需求数据至蜂擎返回结果-pushNeedInfo2Fq-success",pobj, rtn, null);
            return data;
        } catch (e) {
            this.logClient.pushlog("推送投放落地页需求数据至蜂擎返回异常-pushNeedInfo2Fq-error", pobj, null, e.stack);
            return null;
        }
    }
    /**
     * 推送媒体聚合页需求至蜂擎
     * @param {*} pobj 
     */
    async pushMediaNeedInfo2Fq(pobj) {
        try {
            // var url = "https://yunfuapi-dev.gongsibao.com/cloudapi/cyg/lead/fluxAllot";//开发环境
            var url = "https://yunfuapi.gongsibao.com/cloudapi/cyg/lead/fluxAllot";//线上环境
            var rc = system.getObject("util.aliyunClient");
            console.log(rc,"aliyunClient++++++++++++++++++++++++++");
            var rtn = await rc.post(url, pobj);
            console.log(rtn,"rtn+++++++++++++++++++++++++++++++++++++")
            this.logClient.pushlog("推送媒体聚合页需求数据至蜂擎返回结果-pushMediaNeedInfo2Fq-success",pobj, rtn, null);
            return rtn;
        } catch (e) {
            console.log(e,"e+++++++++++++++++++++++++++++++++++++++")
            this.logClient.pushlog("推送投放落地页需求数据至蜂擎返回异常-pushMediaNeedInfo2Fq-error", pobj, null, e.stack);
            return null;
        }
        
      }

}

module.exports = FqUtilsService;
// var task = new FqUtilsService();
// var pobj=
//     {
//         "customer_name": "庄冰测试",
//         "customer_phone": "13075556693",
//         "customer_region": "全国",
//         "demand_list": [{
//             "product_id": "5f4f662fcd9796000a513bdd",
//             "region": "全国"
//         }],
//         "remark": "测试数据",
//         "source_keyword":"百度",
//         "source": "媒体聚合页"
//     };

// task.pushMediaNeedInfo2Fq(pobj).then(d=>{
//     console.log(d,"res++++++++++++++++++++++++++");
// })