const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const { json } = require("sequelize");
class RotationchartService extends ServiceBase {
  constructor() {
    super("aggregation", ServiceBase.getDaoName(RotationchartService));
  }
  async create(pobj) {
    let code = await this.getBusUid("mmc");
    pobj.code = code;
    pobj.pic_type = "2";
    if (!pobj.code) {
      return system.getResultFail(-101, "编码不能为空");
    }
    if (!pobj.pic_url) {
      return system.getResultFail(-101, "图片不能为空");
    }
    if (pobj.is_enabled === '' || pobj.is_enabled === null || pobj.is_enabled === undefined) {
      return system.getResultFail(-103, "是否显示不能为空");
    }
    if (!pobj.jump_link_type) {
      return system.getResultFail(-104, "连接不能为空");
    }
    if (pobj.name && pobj.name.length > 20) {
      return system.getResultFail(-105, "图片名称最多20位字符");
    }
    if (pobj.id !== 1) {
      if (!pobj.sequence) {
        return system.getResultFail(-102, "排序不能为空");
      }
    }
    return system.getResultSuccess(this.dao.create(pobj));
  }


  async update(pobj) {
    if (!pobj.pic_url) {
      return system.getResultFail(-101, "图片不能为空");
    }
    if (pobj.is_enabled === '' || pobj.is_enabled === null || pobj.is_enabled === undefined) {
      return system.getResultFail(-103, "是否显示不能为空");
    }
    if (!pobj.jump_link_type) {
      return system.getResultFail(-104, "连接不能为空");
    }
    if (pobj.name && pobj.name.length > 20) {
      return system.getResultFail(-105, "图片名称最多20位字符");
    }
    if (pobj.id !== 1) {
      if (!pobj.sequence) {
        return system.getResultFail(-102, "排序不能为空");
      }
    }
    
    return system.getResultSuccess(this.dao.update(pobj));
  }

  async delete(pobj) {
   
    return system.getResultSuccess(this.dao.delete(pobj));
  }
}
module.exports = RotationchartService;