const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class ProductService extends ServiceBase {
  constructor() {
    super("aggregation", ServiceBase.getDaoName(ProductService));
    this.producttypeDao = system.getObject('db.aggregation.producttypeDao')
  }
  async create(pobj) {
    let code = await this.getBusUid("p");
    pobj.code = code;
    delete pobj["id"];
    return system.getResultSuccess(this.dao.create(pobj));
  }


  async update(pobj) {
    if(pobj.price_type && pobj.price_type==3){
      pobj.price=0;
      pobj.original_price=0;
    }
    await this.dao.update(pobj);
    return system.getResultSuccess();
  }

  /**
   * 获取某一类下的产品
   * @create rxs
   * @param pobj
   * @returns {Promise<void>}
   */
  async getProductsByType(pobj) {
    const type = await this.producttypeDao.findOne({ code: pobj.typeName }, []);
    if (!type) {
      return system.getResultFail(-1, '获取产品类型数据失败');
    }
    let products = await this.dao.model.findAll({
      attributes: ["code", "name"],
      where: { product_type_id: type.id, is_enabled: 1 }, raw: true
    });
    return system.getResult(products)
  }
}
module.exports = ProductService;