const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class PopularrecommendationService extends ServiceBase {
  constructor() {
    super("aggregation", ServiceBase.getDaoName(PopularrecommendationService));
  }

  async update(pobj) {

    if (!pobj.pic_url) {
      return system.getResultFail(-101, "图片不能为空");
    }
    if (!pobj.jump_link_type) {
      return system.getResultFail(-104, "连接不能为空");
    }
    if (pobj.pic_describe && pobj.pic_describe.length > 20) {
      return system.getResultFail(-105, "图片描述最多20位字符");
    }
    return system.getResultSuccess(this.dao.update(pobj));
  }
}
module.exports = PopularrecommendationService;