const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class PicturewarehouseService extends ServiceBase {
  constructor() {
    super("aggregation", ServiceBase.getDaoName(PicturewarehouseService));
  }

  async create(pobj) {
    let code = await this.getBusUid("img");
    pobj.code = code;
    if (!pobj.pic_url) {
      return system.getResultFail(-123, "图片不能为空");
    }
    return system.getResultSuccess(this.dao.create(pobj));
  }


  async update(pobj) {
    if (!pobj.pic_url) {
      return system.getResultFail(-123, "图片不能为空");
    }
    return system.getResultSuccess(this.dao.update(pobj));
  }

  async delete(pobj) {
    return system.getResultSuccess(this.dao.delete(pobj));
  }
}
module.exports = PicturewarehouseService;