const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class CluemaintenanceService extends ServiceBase {
  constructor() {
    super("aggregation", ServiceBase.getDaoName(CluemaintenanceService));
  }

  async create(pobj) {
    let code = await this.getBusUid("img");
    pobj.code = code;
    if (!pobj.pic_url) {
      return system.getResultFail(-123, "图片不能为空");
    }
    return system.getResultSuccess(this.dao.create(pobj));
  }


  async update(pobj) {
    let whereParams = {
      id: pobj.id
    }
    let res = await this.dao.findOne(whereParams,[]);
    
    if(!pobj.id){
      return system.getResultFail(-124, "未知图片信息");
    }
    if(!pobj.pic_url){
      pobj.pic_url = res.pic_url;
    }
    if(!pobj.pic_size){
      pobj.pic_size = res.pic_size;
    }
    if(!pobj.name){
      pobj.name = res.name;
    }
    return system.getResultSuccess(this.dao.update(pobj));
  }

  /**
   * 线索编辑
   * @param pobj
   * @returns {Promise<void>}
   */
  async updateCluteInfo(pobj){
    if(!pobj.data){
      return system.getResultFail(-1,'线索数据不能为空')
    }
    let data = pobj.data;
    let type = pobj.formitem_type;
    let clueInfo = {
      type:type,
      data:data
    };
    pobj.clue_info = clueInfo;
    const upt = await this.dao.update(pobj);
    return system.getResult(upt);
  }
}
module.exports = CluemaintenanceService;