/**
 * 表单信息表
 * @param db
 * @param DataTypes
 * @returns {Model|void|*}
 */
module.exports = (db, DataTypes) => {
    return db.define("formitem", {
        form_id: {//表单id
            type: DataTypes.INTEGER
        },
        code: {//表单编码
            type: DataTypes.STRING
        },
        name: {//表单名称
            type: DataTypes.STRING
        },
        item_type: {//表单类型
            type: DataTypes.STRING
        },
        item_type_name: {//表单类型名称
            type: DataTypes.STRING
        },
        config_params: {//表单配置参数
            type: DataTypes.JSON
        },
        is_enabled: {//显示状态
            type: DataTypes.BOOLEAN
        },
        is_required: {//是否必填
            type: DataTypes.BOOLEAN
        },
        sequence: {//次序
            type: DataTypes.INTEGER
        },
        notes: {//备注
            type: DataTypes.STRING()
        },
    }, {
        paranoid: true,//假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        tableName: 'c_form_item',
        validate: {},
        indexes: []
    });
}

