const system = require("../../../system");
const settings = require("../../../../config/settings");
const appconfig = system.getSysConfig();
const pic_type = {"1":"列表头图", "2":"首页轮播图"};
/**
 * 轮播图表
 */
module.exports = (db, DataTypes) => {
    return db.define("rotationchart", {
        code: {
            type: DataTypes.STRING
        },
        name: {
            type: DataTypes.STRING
        },
        company_id: {
            type: DataTypes.INTEGER
        },
        is_enabled: {
            type: DataTypes.INTEGER
        },
        pic_url: {
            type: DataTypes.STRING
        },
        pic_type_name: {
            type: DataTypes.STRING
        },
        pic_type: {
            type: DataTypes.STRING,
            set: function (val) {
                this.setDataValue("pic_type", val);
                this.setDataValue("pic_type_name",pic_type[val]);
              }
        },
        sequence: {
            type: DataTypes.INTEGER
        },
        jump_link_type: {
            type: DataTypes.INTEGER
        },
        jump_link: {
            type: DataTypes.STRING
        }

    },
        {
            paranoid: true,//假的删除
            underscored: true,
            version: true,
            freezeTableName: true,
            //freezeTableName: true,
            // define the table's name
            tableName: 'mc_rotation_chart',
            validate: {

            },
            indexes: [
                // Create a unique index on email
                //  {
                //    unique: true,
                //    fields: ['email']
                //  },
                //
                //  // Creates a gin index on data with the jsonb_path_ops operator
                //  {
                //    fields: ['data'],
                //    using: 'gin',
                //    operator: 'jsonb_path_ops'
                //  },
                //
                //  // By default index name will be [table]_[fields]
                //  // Creates a multi column partial index
                //  {
                //    name: 'public_by_author',
                //    fields: ['author', 'status'],
                //    where: {
                //      status: 'public'
                //    }
                //  },
                //
                //  // A BTREE index with a ordered field
                //  {
                //    name: 'title_index',
                //    method: 'BTREE',
                //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
                //  }
            ]
        });
}

