const Sequelize = require('sequelize');
const settings = require("../../../../config/settings")
const Op = Sequelize.Op
const fs = require("fs")
const path = require("path");
var glob = require("glob");
class DbFactory {
  constructor() {
    const dbConfig = settings.database();
    this.db = new Sequelize(dbConfig.dbname,
      dbConfig.user,
      dbConfig.password,
      {
        ...dbConfig.config,
        operatorsAliases: {
          $eq: Op.eq,
          $ne: Op.ne,
          $gte: Op.gte,
          $gt: Op.gt,
          $lte: Op.lte,
          $lt: Op.lt,
          $not: Op.not,
          $in: Op.in,
          $notIn: Op.notIn,
          $is: Op.is,
          $like: Op.like,
          $notLike: Op.notLike,
          $iLike: Op.iLike,
          $notILike: Op.notILike,
          $regexp: Op.regexp,
          $notRegexp: Op.notRegexp,
          $iRegexp: Op.iRegexp,
          $notIRegexp: Op.notIRegexp,
          $between: Op.between,
          $notBetween: Op.notBetween,
          $overlap: Op.overlap,
          $contains: Op.contains,
          $contained: Op.contained,
          $adjacent: Op.adjacent,
          $strictLeft: Op.strictLeft,
          $strictRight: Op.strictRight,
          $noExtendRight: Op.noExtendRight,
          $noExtendLeft: Op.noExtendLeft,
          $and: Op.and,
          $or: Op.or,
          $any: Op.any,
          $all: Op.all,
          $values: Op.values,
          $col: Op.col
        }
      });
    this.db.Sequelize = Sequelize;
    this.db.Op = Op;
    this.initModels();
    this.initRelations();
  }
  async initModels() {
    var self = this;
    var modelpath = path.normalize(path.join(__dirname, '../..')) + "/models/";
    var models = glob.sync(modelpath + "/**/*.js");
    console.log(models.length);
    models.forEach(function (m) {
      console.log(m);
      self.db.import(m);
    });
    console.log("init models....");
  }
  async initRelations() {
    

  }
  //async getCon(){,用于使用替换table模型内字段数据使用
  getCon() {
    var that = this;
    // await this.db.authenticate().then(()=>{
    //   console.log('Connection has been established successfully.');
    // }).catch(err => {
    //   console.error('Unable to connect to the database:', err);
    //   throw err;
    // });
    //同步模型
    if (settings.env == "dev") {

      //console.log(pa);
      // pconfigObjs.forEach(p=>{
      //   console.log(p.get({plain:true}));
      // });
      // await this.db.models.user.create({nickName:"dev","description":"test user",openId:"testopenid",unionId:"testunionid"})
      // .then(function(user){
      //   var acc=that.db.models.account.build({unionId:"testunionid",nickName:"dev"});
      //   acc.save().then(a=>{
      //       user.setAccount(a);
      //   });
      // });
    }
    return this.db;
  }
}
module.exports = DbFactory;
//  const dbf=new DbFactory();
// dbf.getCon().then((db)=>{
//   //console.log(db);
//   // db.models.user.create({nickName:"jy","description":"cccc",openId:"xxyy",unionId:"zz"})
//   // .then(function(user){
//   //   var acc=db.models.account.build({unionId:"zz",nickName:"jy"});
//   //   acc.save().then(a=>{
//   //       user.setAccount(a);
//   //   });
//   //   console.log(user);
//   // });
//   // db.models.user.findAll().then(function(rs){
//   //   console.log("xxxxyyyyyyyyyyyyyyyyy");
//   //   console.log(rs);
//   // })
// });
// const User = db.define('user', {
//     firstName: {
//       type: Sequelize.STRING
//     },
//     lastName: {
//       type: Sequelize.STRING
//     }
// });
// db
//   .authenticate()
//   .then(() => {
//       console.log('Co+nnection has been established successfully.');
//
//       User.sync(/*{force: true}*/).then(() => {
//         // Table created
//         return User.create({
//           firstName: 'John',
//           lastName: 'Hancock'
//         });
//       });
//
//   })
//   .catch(err => {
//     console.error('Unable to connect to the database:', err);
//   });
//
//   User.findAll().then((rows)=>{
//     console.log(rows[0].firstName);
//   });
