var path = require('path');
var ENVINPUT = {
  DB_HOST: process.env.DB_HOST,
  DB_PORT: process.env.DB_PORT,
  DB_USER: process.env.DB_USER,
  DB_PWD: process.env.DB_PWD,
  DB_NAME: process.env.MARKETPLAT_DB_NAME,
  REDIS_HOST: process.env.REDIS_HOST,
  REDIS_PORT: process.env.REDIS_PORT,
  REDIS_PWD: process.env.REDIS_PWD,
  REDIS_DB: process.env.PAAS_REDIS_DB,
  APP_ENV: process.env.APP_ENV ? process.env.APP_ENV : "dev"
};
var settings = {
  env: ENVINPUT.APP_ENV,
  salt: "%iatpD1gcxz7iF#B",
  defaultpwd: "gsb2020",
  basepath: path.normalize(path.join(__dirname, '../..')),
  port: process.env.NODE_PORT || 8003,
  logindex: "center_manage",
  appname: "gsb_marketplat",
  kongurl: function () { if (this.env == "dev") { var localsettings = require("./localsettings"); return localsettings.kongurl; } else { return ENVINPUT.KONG_ADMIAN; } },
  txurl: function () {
    if (this.env == "dev") { var localsettings = require("./localsettings"); return localsettings.txurl; }
    else { return "http://brg-user-center-service"; }
  },
  logUrl: function () {
    if (this.env == "dev") {
      return "http://er.es.gongsibao.com:7200/api/queueAction/producer/springBoard";
    } else {
      return "http://logs-sytxpublic-msgq-service/api/queueAction/producer/springBoard";
    }
  },
  browsingRecordsLogUrl: function () {
    return "http://er.es.gongsibao.com:7200/marketplat_browsingrecords_log/_doc?pretty";
  },
  mediabrowsingRecordsLogUrl: function () {//媒体聚合页访问记录
    return "http://er.es.gongsibao.com:7200/marketmedia_browsingrecords_log/_doc?pretty";
  },
  templateLinkUrl: function () {
    if (this.env == "dev") {
      return "http://192.168.200.208:8081/tfhref";
    } else {
      return "https://marketflow.gongsibao.com/tfhref";
    }
  },
  requrl: function () {
    if (this.env == "dev") {
      return "http://192.168.1.128:4018";
    } else {
      return "http://sytxpublic-msgq-service";
    }
  },
  pmappid: 1,
  pmcompanyid: 1,
  pmroleid: { "ta": 1, "pr": 2 },
  redis: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.redis;
    } else {
      return {
        host: ENVINPUT.REDIS_HOST,
        port: ENVINPUT.REDIS_PORT,
        password: ENVINPUT.REDIS_PWD,
        db: ENVINPUT.REDIS_DB,
      };
    }
  },
  database: function () {
    if (this.env == "dev") {
      var localsettings = require("./localsettings");
      return localsettings.database;
    } else {
      return {
        dbname: ENVINPUT.DB_NAME,
        user: ENVINPUT.DB_USER,
        password: ENVINPUT.DB_PWD,
        config: {
          host: ENVINPUT.DB_HOST,
          port: ENVINPUT.DB_PORT,
          dialect: 'mysql',
          operatorsAliases: false,
          pool: {
            max: 5,
            min: 0,
            acquire: 90000000,
            idle: 1000000
          },
          debug: false,
          timezone: '+08:00',
          dialectOptions: {
            requestTimeout: 999999,
            // instanceName:'DEV'
          }  //设置MSSQL超时时间
        },
      };
    }
  }
};
settings.ENVINPUT = ENVINPUT;
module.exports = settings;
