const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class FormitemService extends ServiceBase {
    constructor() {
        super("configmag", ServiceBase.getDaoName(FormitemService));
        this.templateDao = system.getObject('db.template.templateinfoDao');
    }

    async getFormItemListByFormId(pobj){
        if(!pobj || !pobj.form_id){
            return system.getResultFail(-101,"表单id不能为空");
        }
        var list = await this.dao.model.findAll({
            attributes:[["code","key"],["name","title"]],
            where:{form_id:pobj.form_id,is_enabled:1},
            raw:true,
            order:[["sequence","asc"]]
        });
        return system.getResultSuccess(list);
    }
    /**
     * 创建表单项
     * @param pobj
     * @returns {Promise<void>}
     */
    async createItem(pobj) {
        if(!pobj.name){
            return system.getResultFail(-1,'表单项名称不能为空');
        }
        if(!pobj.sequence){
            return system.getResultFail(-1,'排序不能为空')
        }
        let template = await this.templateDao.findOne({form_id:pobj.form_id},[]);
        if(template && template.is_enabled == 1){
            return system.getResultFail(-1,'表单已投入使用，不能新增表单项');
        }
        let configRet = await this.packageConfigParams(pobj);
        if(configRet.status !== 0){
            return configRet;
        }
        let code = await this.getBusUid('it');
        pobj.config_params = configRet.data;
        pobj.code = code;
        //保存表单项
        let result = await this.create(pobj);
        return system.getResult(result)
    }

    /**
     *
     * @param pobj
     * @returns {Promise<void>}
     */
    async deleteItem(pobj){
        let itemInfo = await this.findOne({id:pobj.id},[]);
        if(['contact_mobile','contact_name'].includes(itemInfo.code)){
            return system.getResultFail(-1,'默认表单项，不能删除');
        }
        let template = await this.templateDao.findOne({form_id:itemInfo.form_id},[]);
        if(template && template.is_enabled == 1){
            return system.getResultFail(-1,'表单已投入使用，不能删除表单项');
        }
        let delRet = await this.delete(pobj);
        return system.getResult(delRet);
    }

    /**
     * 修改表表单项
     * @param pobj
     * @returns {Promise<void>}
     */
    async updateItem(pobj) {
        //参数重组
        if(!pobj.name){
            return system.getResultFail(-1,'表单名称不能为空');
        }
        if(!pobj.sequence){
            return system.getResultFail(-1,'表单排序不能为空')
        }
        let template = await this.templateDao.findOne({form_id:pobj.form_id},[]);
        if(template && template.is_enabled == 1){
            return system.getResultFail(-1,'表单已投入使用，不能修改表单项');
        }
        let configRet = await this.packageConfigParams(pobj);
        if(configRet.status !== 0){
            return configRet;
        }
        pobj.config_params = configRet.data;
        if(['contact_mobile','contact_name'].includes(pobj.code)){
            // return system.getResultFail(-1,'默认表单项，不能修改');
            delete pobj["item_type"];
            delete pobj["item_type_name"];
            delete pobj["is_required"];
            delete pobj["is_enabled"];
            delete pobj["name"];
            delete pobj["sequence"];
            delete pobj["code"];
            //item_type\item_type_name\is_required\is_enabled\name\sequence\code
        }
        let upResult = await this.update(pobj);
        return system.getResult(upResult);
    }

    /**
     * 组装表单项参数
     * @param pobj
     * @returns {Promise<void>}
     */
    async packageConfigParams(pobj){
        let config_params = {};
        switch (pobj.item_type) {
            case "phone":
                if(!pobj.mobile_input_length){
                    return system.getResultFail(-1,'手机号位数选择有误');
                }
                config_params["mobile_input_length"]=pobj.mobile_input_length =="specific" ?1:2;
                config_params["verify_sms"]=pobj.verify_sms==true?1:0;
                break;
            case "singleBtn":
            case "multipleBtn":
            case "downOptions":
                if(!pobj.options){
                    return system.getResultFail(-1,'选项内容不能为空')
                }
                config_params["options"] = pobj.options;
                break;
            case "singleText":
            case "multipleText":
                if(!pobj.input_les || !pobj.input_lar){
                    return system.getResultFail(-1,'请填写字数限制');
                }
                if(pobj.input_lar<pobj.input_les){
                    return system.getResultFail(-1,'字数范围有误');
                }
                let length = []
                length.push(pobj.input_les);
                length.push(pobj.input_lar);
                config_params["input_length"] = length;
                break;
            case "area":
                config_params["is_show_county"] = pobj.is_show_county==true?1:0;
                break;
            default:
                break;
        }
        return system.getResult(config_params);
    }
}

module.exports = FormitemService;