const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class SecondlevelneedconfigService extends ServiceBase {
  constructor() {
    super("aggregation", ServiceBase.getDaoName(SecondlevelneedconfigService));
  }

  async update(pobj) {
    if (!pobj.code) {
      return system.getResultFail(-101, "编码不能为空");
    }
    if (!pobj.top_pic_url) {
      return system.getResultFail(-102, "顶部图标不能为空");
    }
    if (!pobj.recommend_product_quantity) {
      return system.getResultFail(-103, "推荐产品数量不能为空");
    }
    
    return system.getResultSuccess(this.dao.update(pobj));
  }
}
module.exports = SecondlevelneedconfigService;