const ServiceBase = require("../../sve.base");
const system = require("../../../system");
class RedisdelService extends ServiceBase {
  constructor() {
    super("aggregation", ServiceBase.getDaoName(RedisdelService));
    this.redisClient = system.getObject("util.redisClient");
  }

  async redisInfo(functionName, params) {
    var template = "mediaaggregation";
    let shaStr;
    let rtn;
    shaStr = template + "_" + params + "_" + functionName;
    rtn = await this.redisClient.get(shaStr);
    if (rtn) {
      var res = await this.redisClient.delete(shaStr);
      return res;
    }
  }
}

module.exports = RedisdelService;