const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class ProducttypeService extends ServiceBase {
  constructor() {
    super("aggregation", ServiceBase.getDaoName(ProducttypeService));
  }
  async findAndCountAll(obj) {
    let res = await this.dao.findAndCountAll(obj);
    if (obj && obj.search && obj.search.p_id === 0 && res && res.results && res.results.rows && res.results.rows.length > 0) {
      for (var i = 0; i < res.results.rows.length; i++) {
        if (res.results.rows[i].id) {
          var count = await this.dao.findCount({ where: { p_id: res.results.rows[i].id } });
          res.results.rows[i].dataValues.childCount = count;
        }
      }
    }
    return system.getResultSuccess(res);
  }
  async create(pobj) {
    let code = await this.getBusUid("mmc");
    pobj.code = code;
    delete pobj.id;
    if (!pobj.code) {
      return system.getResultFail(-101, "编码不能为空");
    }
    if (!pobj.pic_url) {
      return system.getResultFail(-102, "图标不能为空");
    }
    if (!pobj.sequence) {
      return system.getResultFail(-103, "排序不能为空");
    }

    if (!pobj.name) {
      return system.getResultFail(-105, "名称不能为空");
    }
    // if(!pobj.p_code){
    //   if (pobj.name && pobj.name.length > 4) {
    //     return system.getResultFail(-106, "名称最多4位字符");
    //   }
    // }
    if (pobj.p_code) {
      // if (pobj.name && pobj.name.length > 5) {
      //   return system.getResultFail(-106, "请输入5字以内名称");
      // }
      var p_type = await this.dao.model.findOne({
        where: { code: pobj.p_code, p_id: 0 }, raw: true
      });
      if (!p_type) {
        return system.getResultFail(-300, "产品一类不存在");
      }
      pobj.p_id = p_type.id;
      pobj.p_name = p_type.name;
    } else if (!pobj.jump_link_type || !pobj.jump_link) {
      return system.getResultFail(-104, "连接不能为空");
    }
    return system.getResultSuccess(this.dao.create(pobj));
  }
  async update(pobj) {
    if (!pobj.pic_url) {
      return system.getResultFail(-101, "图标不能为空");
    }
    if (!pobj.sequence && pobj.sequence !== 0) {
      return system.getResultFail(-102, "排序不能为空");
    }
    // if (!pobj.jump_link_type || !pobj.jump_link) {
    //   return system.getResultFail(-104, "连接不能为空");
    // }
    if (!pobj.name) {
      return system.getResultFail(-105, "名称不能为空");
    }
    // if (pobj.name && pobj.name.length > 4) {
    //   return system.getResultFail(-106, "名称最多4位字符");
    // }

    return system.getResultSuccess(this.dao.update(pobj));
  }
  //获取产品类型信息-用于后台管理页面
  async getProductTypeInfo(obj) {
    // if(!obj || !obj.company_id){
    //   return system.getResultFail();
    // }
    var typeones = await this.dao.model.findAll({
      attributes: ["id", "code", "name", "pic_url", "jump_link_type", "jump_link"],
      where: { p_id: 0,code:{[this.db.Op.ne]:'qbfw'}}, raw: true,
      order: [["sequence", "desc"]]
    });
    for (var i = 0; i < typeones.length; i++) {
      if (typeones[i] && typeones[i].id)
        var typetwos = await this.dao.model.findAll({
          attributes: ["id", "code", "name", "pic_url"],
          where: { p_id: typeones[i].id }, raw: true,
          order: [["sequence", "desc"]]
        });
      typeones[i]["children"] = typetwos
    }
    return system.getResultSuccess(typeones);
  }
}
module.exports = ProducttypeService;
// var task = new ProducttypeService();
// task.getProductTypeInfo(null).then(d=>{
//   console.log(JSON.stringify(d));
// })