const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class NeedinfoService extends ServiceBase {
    constructor() {
        super("aggregation", ServiceBase.getDaoName(NeedinfoService));
        this.execClient = system.getObject("util.execClient");
        this.fqUtilsSve = system.getObject("service.common.fqUtilsSve");
        // this.launchchannelDao = system.getObject("dao.configmag.launchchannelDao");
    }
    async findAndCountAll(obj) {
        const apps = await this.dao.findAndCountAll(obj);
        if(apps && apps.results && apps.results.rows){
            for(var i=0;i<apps.results.rows.length;i++){
                if(apps.results.rows[i] && apps.results.rows[i].dataValues && apps.results.rows[i].dataValues.contact_mobile){
                    var mobile = apps.results.rows[i].dataValues.contact_mobile;
                    mobile = mobile.substr(0, 3) + '****' + mobile.substr(7);
                    apps.results.rows[i].dataValues.contact_mobile = mobile;
                }
            }
        }
        return apps;
    }
    //推送聚合页需求至蜂擎
    async pushAggregationNeedInfo2fq(ab){
        if(!ab || !ab.id){
            return ;
        }
        var needinfo = await this.dao.model.findOne({
            where:{
                id:ab.id,
                sub_status:1,
                push_status:0
            },
            raw:true
        });
        console.log(JSON.stringify(needinfo),"pushAggregationNeedInfo2fq++++++111111111111111111");
        if(!needinfo || !needinfo.id || !needinfo.business_id || !needinfo.contact_mobile){
            return ;
        }
        var pobj={
                "customer_name": needinfo.contact_name || needinfo.contact_mobile,
                "customer_phone": needinfo.contact_mobile,
                "customer_region": "全国",
                "demand_list": [{
                    "product_id": needinfo.business_id,
                    "region": "全国"
                }],
                "remark": needinfo.original_need,
                "source_keyword":needinfo.channel_name,
                "source": "媒体聚合页"
        };
        console.log(pobj,"pobj###########################2");
        var pushRes = await this.fqUtilsSve.pushMediaNeedInfo2Fq(pobj);
        console.log(pushRes,"pushRes############################3");
        if(pushRes && pushRes.data && pushRes.code && pushRes.code=="200" && pushRes.success ){//推送成功
            await this.dao.update({id:needinfo.id,push_status:1});
        }else if( pushRes && pushRes.errorMsg){
            await this.dao.update({id:needinfo.id,push_status:2,notes:pushRes.errorMsg});
        }else{
            await this.dao.update({id:needinfo.id,push_status:2});
        }
    }

    async getChannelDataStatistic(pobj){
        // var channelList = await this.launchchannelDao.model.findAll
    }

    async getbrowsingrecordlist(obj){
        try {
            var queryObj={
                "query": {
                    "bool": {
                        "must": [],
                        "must_not": [],
                        "should": []
                    }
                },
                "from": 0,
                "size": 20,
                "sort": [{
                    "created_date": {
                      "order": "desc"
                    }
                  }],
                "aggs": {}
            };
            if(obj.channel_code){
                queryObj.query.bool.must.push({
                    "term": {
                        "channel_code": obj.channel_code
                    }
                });
            }
            if(obj.start_date){
                var st = new Date(obj.start_date);
                if(st){
                    st = st.getTime();
                    queryObj.query.bool.must.push({
                        "range": {
                            "created_date": {
                                "gte": st
                            }
                        }
                    })
                }
            }
            if(obj.end_date){
                var et = new Date(obj.end_date);
                if(et){
                    et = et.getTime();
                    queryObj.query.bool.must.push({
                        "range": {
                            "created_date": {
                                "lte": et
                            }
                        }
                    })
                }
            }
            if(obj.from){
                queryObj.from=obj.from
            }
            if(obj.size){
                queryObj.size=obj.size
            }
            var res = await this.execClient.execPostEs(queryObj, "http://er.es.gongsibao.com:7200/marketmedia_browsingrecords_log/_search");
            if(res && res.stdout){
                res = JSON.parse(res.stdout);
                return res;
            }
            return null;
        } catch (e) {
            console.log(e)
            return null;
        }
    }
    
}

module.exports = NeedinfoService;
// var task = new NeedinfoService();
// var obj={
//     id:1
// };
// task.pushAggregationNeedInfo2fq(obj).then(d=>{
//     console.log(d,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
// });