const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class BottommenuconfigService extends ServiceBase {
  constructor() {
    super("aggregation", ServiceBase.getDaoName(BottommenuconfigService));
  }
  async create(pobj) {
    if (!pobj.button_name) {
      return system.getResultFail(-101, "按钮文案不能为空");
    }

    if (!pobj.is_distinguishtime) {
      return system.getResultFail(-102, "分时策略不能为空");
    }

    if (!pobj.strategy_date) {
      return system.getResultFail(-103, "策略日期不能为空");
    }

    if (!pobj.strategy_time) {
      return system.getResultFail(-104, "策略时段不能为空");
    }

    if (!pobj.button_type) {
      return system.getResultFail(-105, "按钮形式不能为空");
    }

    if (!pobj.button_name) {
      return system.getResultFail(-106, "按钮文案不能为空");
    }


    if (!pobj.call_number) {
      return system.getResultFail(-107, "呼叫号码不能为空");
    }

    if (!pobj.else_button_type) {
      return system.getResultFail(-108, "其他按钮形式不能为空");
    }

    if (!pobj.else_button_name) {
      return system.getResultFail(-109, "其他按钮文案不能为空");
    }

    if (!pobj.else_call_number) {
      return system.getResultFail(-110, "其他呼叫号码不能为空");
    }

    return system.getResultSuccess(this.dao.create(pobj));
  }


  async update(pobj) {
    return system.getResultSuccess(this.dao.update(pobj));
  }
}
module.exports = BottommenuconfigService;