/**
 * 投放渠道信息表
 * @param db
 * @param DataTypes
 * @returns {Model|void|*}
 */
const channel_type = {"1":"投放平台", "2":"媒体聚合页"};
module.exports = (db, DataTypes) => {
    return db.define("launchchannel", {
        only_code:DataTypes.STRING(255),//渠道唯一码
        code: DataTypes.STRING(100),//表单编码
        name: DataTypes.STRING(100),//表单名称
        notes: DataTypes.STRING(255),//备注
        user_id: DataTypes.INTEGER(11),//创建用户id
        user_name: DataTypes.STRING(60),//创建用户名称
        company_id: DataTypes.INTEGER(11),
        channel_type_name:DataTypes.STRING(60),//渠道类型名称
        channel_type: {
            type: DataTypes.STRING(60),
            set: function (val) {
                this.setDataValue("channel_type", val);
                this.setDataValue("channel_type_name",channel_type[val]);
            }
        }
    }, {
        paranoid: true,//假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        timestamps: true,
        updated_at: true,
        tableName: 'c_launch_channel',
        validate: {},
        indexes: []
    });
}

