const APIBase = require("../../api.base");
const system = require("../../../system");
const settings = require("../../../../config/settings");
/**
 * 用户端调用订单相关接口
 */
class Zhugeio extends APIBase {
    constructor() {
        super();
        this.datastatisticSve = system.getObject("service.aggregation.datastatisticSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        var self = this;
        pobj.xctx = req.xctx;
        switch (action_type) {
            case "test"://测试
                opResult = system.getResultSuccess("测试接口");
                break;
            case "synchronizeStatisticDataByZhugeIO"://同步页面访问统计数据
                opResult = await this.datastatisticSve.synchronizeStatisticDataByZhugeIO();
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = Zhugeio;
