const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class AuthService extends ServiceBase {
  constructor() {
    // 1000000 报文参数问题  1001001 签名错误  1002001费用不足  1002002 订单未设置该产品
    super();

    this.feeSve = system.getObject("service.fee.feeSve");
    this.orderSve = system.getObject("service.order.orderSve");
    this.orderauthlogSve = system.getObject("service.order.orderauthlogSve");
    this.enginesignSve = system.getObject("service.engine.enginesignSve");
    this.tradelogDao = system.getObject("db.common.tradelogDao");
  }
  async nameTwo(params) {
    try {
      let idName = this.trim(params.idName);
      let idNo = this.trim(params.idNo).toUpperCase();
      if (!idName) {
        return system.getResultFail(1000000, "姓名错误");
      }
      if (!idNo) {
        return system.getResultFail(1000000, "身份证错误");
      }
      params.apiName = "nameTwo";
      return this.authentication(params, async (p) => {
        return await this.enginesignSve.TwoFactorVerification({
          id_name: idName,
          id_no: idNo,
          channel: p.orderProduct.channel,
          auth_type: 2,
        });
      });
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `系统错误 错误信息 ${error}`);
    }
  }
  async bankThree(params) {
    try {
      let idName = this.trim(params.idName);
      let idNo = this.trim(params.idNo).toUpperCase();
      let bankNo = this.trim(params.bankNo);
      if (!idName) {
        return system.getResultFail(1000000, "姓名错误");
      }
      if (!idNo) {
        return system.getResultFail(1000000, "身份证错误");
      }
      if (!bankNo) {
        return system.getResultFail(1000000, "银行卡号错误");
      }
      params.apiName = "bankThree";
      return this.authentication(params, async (p) => {
        let validRes = await this.enginesignSve.ThreeFactorVerification({
          id_name: idName,
          id_no: idNo,
          bank_no: bankNo,
          channel: p.orderProduct.channel,
          auth_type: 2,
        });
        return validRes;
      });
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  async bankFour(params) {
    try {
      let idName = this.trim(params.idName);
      let idNo = this.trim(params.idNo).toUpperCase();
      let bankNo = this.trim(params.bankNo);
      let mobile = this.trim(params.mobile);
      if (!idName) {
        return system.getResultFail(1000000, "姓名错误");
      }
      if (!idNo) {
        return system.getResultFail(1000000, "身份证错误");
      }
      if (!bankNo) {
        return system.getResultFail(1000000, "银行卡号错误");
      }
      if (!mobile) {
        return system.getResultFail(1000000, "银行卡号错误");
      }
      params.apiName = "bankFour";
      return this.authentication(params, async (p) => {
        let validRes = await this.enginesignSve.FourFactorVerification({
          id_name: idName,
          id_no: idNo,
          bank_no: bankNo,
          mobile: mobile,
          channel: p.orderProduct.channel,
          auth_type: 2,
        });
        return validRes;
      });
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async authentication(params, validMethod) {
    let app = params.app;
    let merchantId = app.merchant_id;

    // 获取订单产品
    let orderProduct = await this.orderSve.getMerchantOrderProduct(merchantId, params.apiName);
    if (orderProduct.status !== 0) {
      return orderProduct;
    }
    orderProduct = orderProduct.data;
    params.orderProduct = orderProduct;
    // 扣费
    let tres = await this.trade(params);
    if (tres.status !== 0) {
      return tres;
    }
    let tradeLog = tres.data.tradeLog;
    let trade = tres.data.trade;

    // 2. 调用认证引擎
    let res = await validMethod(params);
    let pass = res.status === 0;
    // 生成订单
    let logres = await this.orderauthlogSve.saveEorderAuthLog({
      order_id: orderProduct.id,
      product_id: orderProduct.product_id,
      platform_name: app.name,
      platform_id: app.id,
      spended_num: trade.trade_amt,
      user_name: params.idName,         // 使用方
      actual_spend_name: app.merchant_name,// 实际使用方
      engine_trade_id: trade.id,
      pass: pass ? 1 : 0
    });
    console.log(logres);
    // 4. 返回认证结果
    return system.getResultSuccess({pass: pass}, res.msg);
  }

  // 交易
  async trade(params) {
    let orderProduct = params.orderProduct;

    let trade_amt = 1;
    if (orderProduct == 2) {
      trade_amt = Number(orderProduct.price);
    }

    let tradeLog = await this.tradelogDao.create({
      requestid: params.requestid,
      merchant_id: orderProduct.merchant_id,
      product_id: orderProduct.product_id,
      trade_amt: trade_amt,
      result: 0,
    });


    let tradeRes = await this.feeSve.trade({
      account_id: orderProduct.engine_account_id,
      trade_amt: trade_amt,
      trade_no: tradeLog.id,
      trade_desc: "二要素验证",
    });
    if (tradeRes.status !== 0) {
      tradeLog.result = 2;
      tradeLog.fee = 0;
      tradeLog.fee_remark = "扣费失败，" + tradeRes.msg;
      await tradeLog.save();
      return system.getResultFail(1002001, "扣费失败，" + tradeRes.msg);
    } else {
      tradeLog.result = 1;
      tradeLog.fee = 1;
      tradeLog.fee_remark = "扣费成功";
      await tradeLog.save();
    }
    return system.getResultSuccess({
      tradeLog: tradeLog,
      trade: tradeRes.data
    })
  }
}

module.exports = AuthService;