const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class OrderService extends ServiceBase {
    constructor() {
        super();
        this.orderproductSve = system.getObject("service.order.orderproductSve");
        this.productSve = system.getObject("service.product.productSve");
    }

    async getMerchantOrderProduct(merchantId, apiPrev) {
        let orderProductList = await this.orderproductSve.getMerchantLiveProduct({merchant_id: merchantId});
        if (!orderProductList || orderProductList.length == 0) {
            return system.getResultFail(1002001, "暂无可用订单，请先下单");
        }

        let productIds = [];
        for (let op of orderProductList) {
            productIds.push(Number(op.product_id || 0));
        }

        let productMap = await this.productSve.getMapByIds({ids: productIds});
        productMap = productMap.data;
        let orderProduct;
        for (let op of orderProductList) {
            let product = productMap[Number(op.product_id || 0)];
            if (product.api && product.api.startsWith(apiPrev)) {
                orderProduct = op;
                orderProduct.channel = Number(product.api.split("_")[1]);
                break;
            }
        }
        if (!orderProduct) {
            return system.getResultFail(1002002, "订单未设置该产品");
        }
        return system.getResultSuccess(orderProduct);
    }


}

module.exports = OrderService;