const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class MerchantService extends ServiceBase {
    constructor() {
        super();
        this.redisClient = system.getObject("util.redisClient");
        this.APP_CACHE_KEY = "APP_CACHE_KEY_";
    }

    async apiInfoById(params) {
        let apires = await this.callms("sve_merchant", "apiInfoById", params) || {};
        return apires.data;
    }

    async apiWidthCache(params) {
        try {
            let key = this.APP_CACHE_KEY + params.app_id;
            let app = await this.redisClient.get(key);
            if (app) {
                app = JSON.parse(app);
            }
            if(!app || !app.id || params.forceUpdate) {
                app = await this.apiInfoById(params);
                if (!app) {
                    // TODO 缓存穿透，暂时不做，没时间了
                    return null;
                }
                await this.redisClient.setWithEx(key, JSON.stringify(app), 60 * 5);
                return app;
            }
            return app;
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }
}

module.exports = MerchantService;
