const system = require("../../../system");
const settings = require("../../../../config/settings");
const ServiceBase = require("../../svems.base")

class EngineSignService extends ServiceBase {
    constructor() {
        super();
        // "createAccount": `${domain}/sign/account/create/person`,
        // "createTemplate": `${domain}/sign/template/create`,
        // "autoSign": `${domain}/sign/contract/autoSign`,
        // "handSign": `${domain}/sign/contract/handSign`,
        // "signCallBack": `${domain}/sign/contract${domain}/signCallBack`,
        // "signQuery": `${domain}/sign/contract${domain}/signQuery`
        this.API = settings.signApi();
    }


    /*
    *二要素验证
    * 姓名：id_name
    *身份证：id_no
    *
    * */

    async TwoFactorVerification(params) {
        try {
            return await this.callms("engine_auth", "TwoFactorVerification", params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    /* 三要素验证
     * 姓名：id_name
     *身份证：id_no
     *银行卡：bank_no
    * */
    async ThreeFactorVerification(params) {
        try {
            return await this.callms("engine_auth", "ThreeFactorVerification", params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    /*四要素验证
    * 姓名：id_name
    *身份证：id_no
    *银行卡：bank_no
    *手机号：mobile
* */
    async FourFactorVerification(params) {
        try {
            return await this.callms("engine_auth", "FourFactorVerification", params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }


    // 创建模板
    async createTemplate(params) {
        try {
            return await this.callApi(this.API.createTemplate, params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    // 创建个人账户
    async createAccount(params) {
        try {
            return await this.callApi(this.API.createAccount, params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    // 手动签
    async handSign(params) {
        try {
            return await this.callApi(this.API.handSign, params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    // 静默签
    async autoSign(params) {
        try {
            return await this.callApi(this.API.autoSign, params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    // 签约回调
    async signCallBack(params) {
        try {
            return await this.callApi(this.API.signCallBack, params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    // 签约查询
    async signQuery(params) {
        try {
            return await this.callApi(this.API.signQuery, params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    // 企业模板印章
    async organize(params) {
        try {
            return await this.callApi(this.API.organize, params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }

    // // 企业图片印章
    // async signQuery(params) {
    //     try {
    //         return await this.callApi(this.API.signQuery, params);
    //     } catch (error) {
    //         return system.getResult(null, `系统错误 错误信息 ${error}`);
    //     }
    // }
    //
    // // 个人图片印章
    // async signQuery(params) {
    //     try {
    //         return await this.callApi(this.API.signQuery, params);
    //     } catch (error) {
    //         return system.getResult(null, `系统错误 错误信息 ${error}`);
    //     }
    // }

    //id查询list
    async contentByDocIds(params) {
        try {
            return await this.callApi(this.API.contentByDocIds, params);
        } catch (error) {
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }
}

module.exports = EngineSignService;
