var APIBase = require("../../api.base");
var system = require("../../../system");

class SignAPI extends APIBase {
    constructor() {
        super();
        this.signSve = system.getObject("service.sign.signSve");
    }

    /**
     * 创建模板
     * @param pobj
     * @returns {Promise<{msg: *, data: *, status: *}|*|undefined>}
     */
    async createTemplate(pobj, query, req) {
        try {
            return await this.signSve.createTemplate(pobj);
        } catch (e) {
            console.log(e);
            return system.getResultFail(500, "请求异常")
        }
    }

    /**
     * 创建个人账户
     * @param req
     * @returns {Promise<{msg: *, data: *, status: *}|*|undefined>}
     */
    async createAccount(pobj, query, req) {
        try {
            return await this.signSve.createAccount(pobj);
        } catch (e) {
            console.log(e);
            return system.getResultFail(500, "请求异常")
        }
    }

    /**
     * 创建企业印章
     * @param req
     * @returns {Promise<{msg: *, data: *, status: *}|*|undefined>}
     */
    async createEntSeal(pobj, query, req) {
        try {
            return await this.signSve.createEntSeal(pobj);
        } catch (e) {
            console.log(e);
            return system.getResultFail(500, "请求异常")
        }
    }

    // 静默签
    async autoSign(pobj, query, req) {
        try {
            return await this.signSve.autoSign(pobj);
        } catch (e) {
            console.log(e);
            return system.getResultFail(500, "请求异常")
        }
    }

    // 手动签
    async handSign(pobj, query, req) {
        try {
            return await this.signSve.handSign(pobj);
        } catch (e) {
            console.log(e);
            return system.getResultFail(500, "请求异常")
        }
    }


    async contentByDocIds(pobj, query, req) {
        try {
            return await this.signSve.handSign(pobj);
        } catch (e) {
            console.log(e);
            return system.getResultFail(500, "请求异常")
        }
    }

    exam() {
        return "";
    }

    classDesc() {
        return {
            groupName: "",
            groupDesc: "",
            name: "",
            desc: "",
            exam: "",
        };
    }

    methodDescs() {
        return [
            {
                methodDesc: "",
                methodName: "",
                paramdescs: [
                    {
                        paramDesc: "",
                        paramName: "",
                        paramType: "",
                        defaultValue: "",
                    }
                ],
                rtnTypeDesc: "",
                rtnType: ""
            }
        ];
    }
}

module.exports = SignAPI;
