const APIBase = require("../../api.base");
const system = require("../../../system");
const settings = require("../../../../config/settings");
const md5 = require("md5");
class ActionAPI extends APIBase {
    constructor() {
        super();
        this.authSve = system.getObject("service.sign.authSve");
        this.merchantSve = system.getObject("service.merchant.merchantSve");
        // this.userSve = system.getObject("service.user.userSve");
        this.enginsignSve = system.getObject("service.engine.enginesignSve");
    }
    /**
     * 接口跳转
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async springboard(pobj, qobj, req) {
        let result;
        if (!pobj.action_process) {
            return system.getResult(null, "action_process参数不能为空");
        }
        if (!pobj.action_type) {
            return system.getResult(null, "action_type参数不能为空");
        }
        try {
            result = await this.handleRequest(pobj.action_process, pobj.action_type, pobj.action_body);
        } catch (error) {
            console.log(error);
            // TODO 抓取validsign error并返回
        }
        return result;
    }

    async handleRequest(action_process, action_type, action_body) {
        var opResult = null;
        switch (action_type) {
            // 姓名二要素
            case "nameTwo":
                opResult = await this.authSve.nameTwo(action_body);
                break;
            // 银行卡三要素
            case "bankThree":
                // opResult = await this.userSve.saveMerchantUser(action_body);
                break;
                // 银行卡四要素
            case "bankFour":
                // opResult = await this.userSve.adminLogin(action_body);
                break;
                // 创建账号
            case "createAccount":
                // opResult = await this.userSve.merchantLogin(action_body);
                break;
                // 创建模板
            case "createTemplate":
                // opResult = await this.userSve.merchantLogin(action_body);
                break;
                // 手动签约
            case "handSign":
                // opResult = await this.userSve.merchantLogin(action_body);
                break;
            case "autoSign":
                 opResult = await this.enginsignSve.autoSign(action_body);
                break;
            case "organize":
                opResult = await this.enginsignSve.organize(action_body);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

    exam() {
        return `<pre><pre/>`;
    }
    classDesc() {
        return {
            groupName: "op",
            groupDesc: "元数据服务包",
            name: "ActionAPI",
            desc: "此类是对外提供接口服务",
            exam: "",
        };
    }
    methodDescs() {
        return [
            {
                methodDesc: `<pre><pre/>`,
                methodName: "springboard",
                paramdescs: [
                    {
                        paramDesc: "请求的行为，传递如：sjb",
                        paramName: "action_process",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型，详情见方法中的描述",
                        paramName: "action_type",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型的参数，action_body必须传递的参数有，times_tamp（时间戳，类型int）、sign(签名,类型string)，其余的为业务需要的参数",
                        paramName: "action_body",
                        paramType: "json",
                        defaultValue: null,
                    }
                ],
                rtnTypeDesc: `<pre><pre/>`,
                rtnType: `<pre><pre/>`
            }
        ];
    }
}
module.exports = ActionAPI;
