const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
class Push2aliService extends ServiceBase {
  constructor() {
    super("common", ServiceBase.getDaoName(Push2aliService));
    this.pushlogDao=system.getObject("db.common.pushlogDao");
    this.pushAliUrl = settings.centerChannelUrl();
  }
  //推送数据至阿里
  async pushData2Ali(obj){
    if(!obj.url){
      return system.getResultFail(-501,"推送url不能为空");
    }
    var rtn = "";
    var url = this.pushAliUrl + "tradetransfer/aliclienttransfer";
    var action = obj.url;
    var pushObj = obj.pushObj;
    try {
      var rc = system.getObject("util.execClient");
      var actionBody = {action:action,reqbody:pushObj};
      rtn = await rc.execPost({actionBody:actionBody},url);
      var logObj ={
        appid: obj.appInfo ? obj.appInfo.uapp_id : "",
        appkey: obj.appInfo ? obj.appInfo.uapp_key : "",
        op: url,
        content: JSON.stringify(obj),
        resultInfo: rtn?JSON.stringify(rtn):""
      };
      if (!rtn || !rtn.stdout) {
        logObj["returnType"]="0";
        logObj["opTitle"]="数据推送ali返回失败";
        this.pushlogDao.create(logObj);
        return system.getResultFail(-502,"execPost data is empty");
      }else{
        logObj["returnType"]="1";
        logObj["opTitle"]="数据推送ali返回成功";
        this.pushlogDao.create(logObj);
        var stdout = JSON.parse(rtn.stdout);
        return system.getResultSuccess(stdout);
      }
    } catch (e) {
      this.pushlogDao.create({
        appid: obj.appInfo ? obj.appInfo.uapp_id : "",
        appkey: obj.appInfo ? obj.appInfo.uapp_key : "",
        logLevel:"3",
        op: url,
        content:JSON.stringify(obj),
        resultInfo: JSON.stringify(e.stack),
        returnType:"0",
        opTitle:"数据推送ali---异常"
      });
      return system.getResultFail(-500,JSON.stringify(e.stack));
    }
    
  }

}
module.exports = Push2aliService;
