const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("orderproduct", {
    uapp_id: DataTypes.INTEGER,//
    sourceOrderNo         :DataTypes.STRING(128),//来源单号 
    productType_id        :DataTypes.INTEGER,//产品类型Id
    pathCode              :DataTypes.STRING(512), //产品类型编码路径，如：1/2
    pathName              :DataTypes.STRING(512), //产品类型路径名称，如：1/2
    itemCode              :DataTypes.STRING(64),//产品编码
    itemName              :DataTypes.STRING(100),//产品名称                                               
    channelItemCode       :DataTypes.STRING(100),//  渠道产品编码                                                 
    channelItemName       :DataTypes.STRING(100),//  渠道产品名称 
    channelItemAppendName :DataTypes.STRING(500),//  渠道产品附加名称 --如商标名称
    serviceItemCode       :DataTypes.STRING(100),//  服务商产品编码
    payAfterJumpH5Url     :DataTypes.STRING(500),
    payAfterJumpPcUrl     :DataTypes.STRING(500),
    picUrl                :DataTypes.STRING(500),//  产品图片地址      
    price                 :DataTypes.DOUBLE,    //  产品价格   
    priceDesc             :DataTypes.STRING, //定价描述    
    priceTypeName         :DataTypes.STRING(10), //定价类型名称
    quantity              :DataTypes.INTEGER,//  订单数量（即产品的倍数，默认值为1）   
    opPayType             :DataTypes.STRING(10),//  操作付款类型:00: 创建订单, 10: 补单
    serviceItemSnapshot   :DataTypes.TEXT('long'),      //产品快照
    orderSnapshot         :DataTypes.TEXT('long') //订单快照
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'c_order_product',
      validate: {

      },
      indexes: [
      ]
    });
}
