const system = require("../../../system");
const Dao = require("../../dao.base");
const {Op} = require("sequelize");
class OrderinfofqDao extends Dao {
  constructor() {
    super(Dao.getModelName(OrderinfofqDao));
  }

  /**
   * 取300条未处理的数据
   * @returns {Promise<Array<Model>>}
   */
  async getAllOrders(){
    let fqNeeds = await this.findAll({
      where: {
        handleStatus: 0
      },
      order: [["id","desc"]],
      limit: 300
    })
    return fqNeeds;
  }

  /**
   * 批量更新
   * @param needs
   * @returns {Promise<Array<Model>|*>}
   */
  async bulkUpdate(ids){
    let result = await this.updateByWhere({handleStatus:1},{
      where : {
        channelOrderNo:{
          [Op.in]:ids
        }
      }
    });
    return result;
  }
}
module.exports = OrderinfofqDao;
