var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class OrderAPI extends APIBase {
    constructor() {
        super();
        this.orderinfoSve = system.getObject("service.dbcorder.orderinfoSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "icOrderStatusNotify"://操作工商流程通知信息
                opResult = await this.orderinfoSve.icOrderStatusNotify(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = OrderAPI;