var APIBase = require("../../api.base");
var system = require("../../../system");
class CollectAPI extends APIBase {
  constructor() {
    super();
    this.collectSve = system.getObject("service.askfor.collectSve");
  }

  async tradeMark (pobj, qobj, req) {
    if (!pobj.userInfo) {
      return system.getResultFail(system.noLogin, "user no login!");
    }
    if (!pobj.actionType) {
      return system.getResult(null, "actionType参数不能为空");
    }
    let result
    switch (pobj.actionType) {
      case 'getByUid':
        result = await this.collectSve.getByUid(pobj.userInfo.id, pobj.actionBody.page, pobj.actionBody.offset)
        return system.getResult2(result)

      case 'getByUidAndCollections':
        result = await this.collectSve.getByUidAndCollections(pobj.userInfo.id, pobj.actionBody.collections)
        return system.getResult2(result)
      case 'create':
        let param = {}
        param.user_id = pobj.userInfo.id
        delete pobj.actionBody.type
        param.c_content = JSON.stringify(pobj.actionBody)
        param.c_type = 1
        result = await this.collectSve.create(param)
        return system.getResult2(result)
      case 'delete':
        result = await this.collectSve.delete(pobj.actionBody.id)
        return system.getResult2(result)
    }
  }
}
module.exports = CollectAPI;