var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ucommuneOrder extends APIBase {
    constructor() {
        super();
        this.orderinfoSve = system.getObject("service.dbcorder.orderinfoSve");
        this.ucommuneOrderSve = system.getObject("service.dbcorder.ucommuneOrderSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.appInfo) {
            return system.getResult(null, "请检查token,100460");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "ucommuneGetOrderList":// uk后端订单拉取功能
                opResult = await this.ucommuneOrderSve.getOrderInfo(pobj,pobj.actionBody);
                break;
            case "getStatistics":// 概览-业务统计
                opResult = await this.ucommuneOrderSve.getStatistics(pobj, pobj.actionBody);
                break;
            case "getTrend":// 概览-业务统计
                opResult = await this.ucommuneOrderSve.getTrend(pobj, pobj.actionBody);
                break;
            case "getProductTypesales":// 概览-产品销售分布
                opResult = await this.ucommuneOrderSve.getProductTypesales(pobj, pobj.actionBody);
                break;
            case "getCustomerArea":// 概览-客户地域分布
                opResult = await this.ucommuneOrderSve.getCustomerArea(pobj, pobj.actionBody);
                break;
            case "getOrderDeliveryInfo":// 订单列表
                opResult = await this.ucommuneOrderSve.getOrderDeliveryInfo(pobj, pobj.actionBody);
                break;
            case "getOrderDelivery":// 订单详情
                opResult = await this.ucommuneOrderSve.getOrderDelivery(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = ucommuneOrder;