var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class NameOrderAPI extends APIBase {
    constructor() {
        super();
        this.orderinfoSve = system.getObject("service.dbcorder.orderinfoSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        // if (!pobj.userInfo) {
        //     return system.getResultFail(system.noLogin, "user no login!");
        // }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "addOrderDelivery":
                opResult = await this.addOrderDelievry(pobj,pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

    //起名宝起名信息保存
    async addOrderDelievry(pobj,actionBody){
        let result ={};
        if(!actionBody.orderId){
            return system.getResult(null, "orderId is empty")
        }
        const sourceOrderNo = actionBody.orderId;
        result.result_name = actionBody.result_name;
        await this.orderinfoSve.addOrderDelivery(result,sourceOrderNo);
        return system.getResultSuccess({
            orderNo: sourceOrderNo
        });
    }

}
module.exports = NameOrderAPI;