var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class IcAPI extends APIBase {
    constructor() {
        super();
        // this.utilsProductSve = system.getObject("service.utilsSve.utilsProductSve");
        this.needsolutionSve = system.getObject("service.dbneed.needsolutionSve");
        this.needinfoSve = system.getObject("service.dbneed.needinfoSve");
        this.orderinfoSve = system.getObject("service.dbcorder.orderinfoSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        if (pobj.actionType == 'getPolicyNeedList' || pobj.actionType == 'submitPolicyNeedNotes') {
            if (!pobj.userInfo) {
                return system.getResult(system.noLogin, "user no login!");
            }
            if (!pobj.appInfo) {
                return system.getResult(system.noLogin, "app is null!");
            }
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "submitProgramme"://提交公司注册方案
                opResult = await this.needsolutionSve.submitProgramme(pobj);
                break;
            case "receiveProgrammeNo"://接收方案编号(方案推送至阿里后,接收保存方案信息)
                opResult = await this.needsolutionSve.receiveProgrammeNo(pobj);
                break;
            case "getProgrammeListByUser"://获取方案列表（获取用户所有方案）
                opResult = await this.needsolutionSve.getProgrammeListByUser(pobj);
                break;
            case "getProgrammeInfoByNeedNo"://根据需求查看方案列表
                opResult = await this.needsolutionSve.getProgrammeInfoByNeedNo(pobj);
                break;
            case "receiveFeedback"://接收方案反馈信息(即方案作废)
                opResult = await this.needsolutionSve.receiveFeedback(pobj, req);
                break;
            case "abolishProgramme"://服务商方案作废
                opResult = await this.needsolutionSve.abolishProgramme(pobj);
                break;
            case "submitSolution"://提交需求
                opResult = await this.needinfoSve.createicneedinfo(pobj);
                break;
            case "paySuccess"://支付成功回调
                opResult = await this.orderinfoSve.createsolutionOrder(pobj);
                break;
            case "solutionClose"://需求关闭
                opResult = await this.needinfoSve.solutionClose(pobj);
                break;
            case "abolishProgrammeByNeed"://根据需求关闭方案（关闭需求后调用）
                opResult = await this.needsolutionSve.abolishProgrammeByNeed(pobj);
                break;
            case "createSolutionByOrder"://立即支付下单保存方案
                opResult = await this.needsolutionSve.createSolutionByOrder(pobj);
                break;
            case "receiveSolutionPayInfo"://接收方案状态及支付信息(方案支付后创建订单时调用)
                opResult = await this.needsolutionSve.receiveSolutionPayInfo(pobj);
                break;
            case "updateStausByRefundOrder"://修改退款方案状态
                opResult = await this.needsolutionSve.updateStausByRefundOrder(pobj);
                break;
            case "getProgrammeInfoByChannelSolutionNo"://修改退款方案状态
                opResult = await this.needsolutionSve.getProgrammeInfoByChannelSolutionNo(pobj);
                break;
            // --------------庄冰2020.10.21-------百度Icp接入使用--------start------------------
            case "receiveSolutionPayInfoNew"://接收方案状态及支付信息(方案支付后创建订单时调用)
                opResult = await this.needsolutionSve.receiveSolutionPayInfoNew(pobj);
                break;
            // --------------庄冰2020.10.21-------百度Icp接入使用--------end------------------
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = IcAPI;