var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class FgbusinesschanceAPI extends APIBase {
    constructor() {
        super();
        this.fgbusinesschanceSve = system.getObject("service.dbcorder.fgbusinesschanceSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "create": //创建复购商机
                opResult = await this.fgbusinesschanceSve.create(pobj, pobj.actionBody);
                break;
            case "createOrderRefundFq":
                opResult = await this.fgbusinesschanceSve.createOrderRefundFq(pobj, pobj.actionBody);
                break;
            case "createOnlineProductClassificiationFq":
                opResult = await this.fgbusinesschanceSve.createOnlineProductClassificiationFq(pobj, pobj.actionBody);
                break;
            case "createOrderInfoAndPayFq":
                opResult = await this.fgbusinesschanceSve.createOrderInfoAndPayFq(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = FgbusinesschanceAPI;