var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ediApi extends APIBase {
    constructor() {
        super();
        this.orderinfoSve = system.getObject("service.dbcorder.orderinfoSve");
        this.needinfoSve = system.getObject("service.dbneed.needinfoSve");
        this.aliyunqcSve = system.getObject("service.qcutils.aliyunqcSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "produceNoticeAliEsp":// uk后端订单拉取功能
              opResult = await this.needinfoSve.produceNoticeAliEsp(pobj,pobj.actionBody);
              break;
            case "receiveEdiStatusNotify"://接收渠道方案状态变更通知2.3
              opResult = await this.aliyunqcSve.receiveEdiStatusNotify(pobj);
              break;
            case "soulutionFeebackAliEsp"://接收渠道方案状态变更通知2.4
              opResult = await this.aliyunqcSve.soulutionFeebackAliEsp(pobj);
              break;
            default:
              opResult = system.getResult(null, "action_type参数错误");
              break;
        }
        return opResult;
    }

}
module.exports = ediApi;