const BaseClient = require("./baseClient")
const settings = require("../../../config/settings");
const system = require("../../system");
const { appKey, secret } = settings;
/**
 * 网文 产品
 */
class WangwenClient extends BaseClient {
    constructor() {
        super(appKey, secret, "/web/action/qcapi/springBoard");
        this.instance = null;
        this.CIRCUITSTATUS = {
            ACCOUNTREGISTRATION: 507,   // 完成账户注册
            SUBMITING: 508,             // 提交材料到工信部 
            DISPOSEING: 509,            // 工信部已受理
            DISPOSEINGFAIL: 510,        // 工信不予受理
            THROUGH: 511,               // 工信部通过
            THROUGHFAIL: 512             // 工信部未通过
        }
    }

    static getInstance() {
        if (!this.instance) {
            this.instance = new WangwenClient();
        }
        return this.instance;
    }

    async submitMaterials(username, deliverData, materials) {
        const { businessLicense, materialFile, } = materials;
        const {
            address, businessTerm, createdAt,
            enterpriseCode, legalRepresentative, name,
            registeredCapital, scopeBusiness, type
        } = businessLicense;
        const {
            partnerBusinessLicense,
            legalPersonIdentityCard,
            businessDevelopmentDescription,
            companyPolicy,
            mainManagement,
            creditCertificateDocument,
            registeredAddressCertificateDocument,
            partnerOtherList,
        } = materialFile;
        await this.pushQiFuTong(username, {
            actionType: "ncSubmitMaterial",
            actionBody: {
                orderNo: deliverData.delivery_code,
                material: {
                    businessLicense: {
                        address, businessTerm,
                        createdAt: createdAt ? createdAt : undefined,
                        enterpriseCode, legalRepresentative, name,
                        registeredCapital, scopeBusiness, type
                    },
                    partnerBusinessLicense: partnerBusinessLicense.url,
                    legalPersonIdentityCard: legalPersonIdentityCard.url,
                    businessDevelopmentDescription: businessDevelopmentDescription.url,
                    companyPolicy: companyPolicy.url,
                    mainManagement: mainManagement.url,
                    creditCertificateDocument: creditCertificateDocument.url,
                    registeredAddressCertificateDocument: registeredAddressCertificateDocument.url,
                    partnerOtherList: partnerOtherList.url,
                }
            }
        });
    }

    async changeStatus(username, deliverData, materials = {}) {
        let status;
        switch (deliverData.delivery_status) {
            case system.SERVERSESTATUS.USERCONFIRMATIONRESOLVE:
            case system.SERVERSESTATUS.COLLECTSUCCESS:
                status = this.CIRCUITSTATUS.ACCOUNTREGISTRATION
                break
            case system.SERVERSESTATUS.ACCOUNTREGISTRATION:
                status = this.CIRCUITSTATUS.SUBMITING
                break
            case system.SERVERSESTATUS.SUBMITING:
                status = this.CIRCUITSTATUS.DISPOSEING
                break
            case system.SERVERSESTATUS.DISPOSEING:
                status = this.CIRCUITSTATUS.THROUGH
                if (deliverData.delivery_info && deliverData.delivery_info.qualification && deliverData.delivery_info.qualification.url) {
                    materials = {
                        officialFileURL: deliverData.delivery_info.qualification.url
                    }
                }
                break
            case system.SERVERSESTATUS.THROUGH:
                return "SUCCESS"
            default:
                throw new Error("此状态不能手动更改");
        }
        await this.pushQiFuTong(username, {
            actionType: "ncNotification",
            actionBody: {
                orderNo: deliverData.delivery_code,
                status,
                ...materials
            }
        });
    }
}

module.exports = WangwenClient