const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const moment = require("moment");
const pushQft = require("../../../utils/toqifutongClient")
const TOQFT = require("../../../utils/toQft");


class NewdeliverService extends ServiceBase {
    constructor() {
        super("delivery", ServiceBase.getDaoName(NewdeliverService));
        this.cacheinfoDao = system.getObject("db.delivery.cacheinfoDao");
        this.deliveryDao = system.getObject("db.delivery.deliverDao");
        this.newmaterialDao = system.getObject("db.delivery.newmaterialDao");
        this.statuslogDao = system.getObject("db.bizchance.statuslogDao");

    }
    async findInfo(pobj, qobj, req) {
        let result = await this.deliveryDao.newFindInfo({
            id: pobj.id
        });
        if (!result) {
            throw new Error("交付单不可查看");
        }
        return result;
    }

    async submitMaterials(pobj, qobj, req) {
        const deliverData = await this.deliveryDao.findOne({
            id: pobj.deliver_id
        });

        if (!deliverData) {
            throw new Error("查不到此交付单");
        }
        if ([system.SERVERSESTATUS.COLLECTING, system.SERVERSESTATUS.USERCONFIRMATIONREJECT, system.SERVERSESTATUS.FILLING].includes(deliverData.delivery_status)) {
            await TOQFT.getClientByType(deliverData.product_code).submitMaterials(pobj.username, deliverData, pobj.cache_info);
        }

        return this.db.transaction(async (t) => {
            await this.cacheinfoDao.createOrUpdate(pobj, t);
            await this.newmaterialDao.createOrUpdate(pobj, t);
            if ([system.SERVERSESTATUS.COLLECTING, system.SERVERSESTATUS.USERCONFIRMATIONREJECT, system.SERVERSESTATUS.FILLING].includes(deliverData.delivery_status)) {
                let status;
                if (deliverData.source_number === "aliCloud") {
                    status = system.SERVERSESTATUS.USERCONFIRMATIONWAIT
                } else {
                    status = system.SERVERSESTATUS.COLLECTSUCCESS;
                }
                await this.deliveryDao.updateByWhere({
                    delivery_status: status
                }, {
                    id: pobj.deliver_id
                }, t);
                this.statuslogDao.create({
                    flow_type: system.FLOWCODE.DELIVERY,
                    flow_id: pobj.deliver_id,
                    status_code: status,
                    salesman_id: pobj.userid,
                    salesman_name: pobj.username
                });
            }

            // 更新公司名称
            if (pobj && pobj.cache_info && pobj.cache_info.businessLicense && pobj.cache_info.businessLicense.name) {
                await this.deliveryDao.updateByWhere({
                    company_name: pobj.cache_info.businessLicense.name,
                    delivery_info: {
                        ...deliverData.delivery_info,
                        companyName: pobj.cache_info.businessLicense.name
                    }
                }, {
                    delivery_code: deliverData.delivery_code
                }, t);
            }

            return "SUCCESS"
        });
    }

    async changeDeliveryStatus(pobj, qobj, req) {
        const deliverData = await this.deliveryDao.findOne({
            id: pobj.id
        });
        if (!deliverData) {
            throw new Error("没有此交付单");
        }
        let status;
        switch (deliverData.delivery_status) {
            case system.SERVERSESTATUS.USERCONFIRMATIONRESOLVE:
            case system.SERVERSESTATUS.COLLECTSUCCESS:
                status = system.SERVERSESTATUS.ACCOUNTREGISTRATION;
                break
            case system.SERVERSESTATUS.ACCOUNTREGISTRATION:
                status = system.SERVERSESTATUS.SUBMITING;
                break
            case system.SERVERSESTATUS.SUBMITING:
                status = system.SERVERSESTATUS.DISPOSEING;
                break
            case system.SERVERSESTATUS.DISPOSEING:
                status = system.SERVERSESTATUS.THROUGH;
                break
            case system.SERVERSESTATUS.THROUGH:
                status = system.SERVERSESTATUS.SUCCESS;
                break
            default:
                throw new Error("此状态手动不能更改");
        }

        await TOQFT.getClientByType(deliverData.product_code).changeStatus(pobj.username, deliverData);

        await this.deliveryDao.updateByWhere({
            delivery_status: status
        }, {
            id: pobj.id
        })
        this.statuslogDao.create({
            flow_type: system.FLOWCODE.DELIVERY,
            flow_id: pobj.id,
            status_code: status,
            salesman_id: pobj.userid,
            salesman_name: pobj.username
        });
        return "SUCCESS"
    }


    async addQualification(pobj) {

        const deliverData = await this.deliveryDao.findOne({
            id: pobj.id
        });

        if (!deliverData) {
            throw new Error("查不到此交付单");
        }

        await this.deliveryDao.updateByWhere({
            delivery_info: {
                ...deliverData.delivery_info,
                qualification: pobj.file
            }
        }, {
            id: pobj.id
        });

        return "SUCCESS"
    }
}
module.exports = NewdeliverService;
