const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class UserService extends ServiceBase {
  constructor() {
    super();
  }

  async saveMerchantUser(params) {
    try {
      return await this.callms("sve_uc", "saveMerchantUser", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async login(params) {
    try {
      return await this.callms("sve_uc", "merchantLogin", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async page(params) {
    try {
      return await this.callms("sve_uc", "userPage", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async info(params) {
    try {
      return await this.callms("sve_uc", "userInfo", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async resetPassword(params) {
    try {
      return await this.callms("sve_uc", "userResetPassword", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async mapByIds(params) {
    try {
      let res = await this.callms("sve_uc", "userMapByIds", params);
      if (res.status == 0) {
        return res.data;
      }
      return {};
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }



  async setRowsUser(rows, field, objectField) {
    objectField = objectField || "user";
    if (!rows || rows.length == 0 || !field) {
      return;
    }
    let ids = [];
    for (let item of rows) {
      let id = Number(item[field] || 0);
      if(!id) {
        continue;
      }
      ids.push(id);
    }

    let map = await this.mapByIds({ids: ids});
    for (let item of rows) {
      item[objectField] = map[item[field]] || {};
    }
  }
}

module.exports = UserService;
