const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class OrderService extends ServiceBase {
    constructor() {
        super();
    }

    /**
     * fn:查询商户下可用订单的产品(所有)
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<{msg: *, data, bizmsg: *|string, status: number}|*|{msg: string, data, bizmsg: (*|string), status: number}>}
     */
    async getMerchantLiveAllProducts(params){
        return await this.callms("sve_order", "getMerchantLiveAllProducts", params);
    }

    /**
     * fn:根据ID查看订单
     * @param params
     * @returns {Promise<{msg: *, data, bizmsg: *|string, status: number}|any|undefined>}
     */
    async getEorderById(params) {
        return await this.callms("sve_order", "getEorderById", params);
    }

    /**
     * fn:查看订单列表(分页)
     * @param params
     * @returns {Promise<{msg: *, data, bizmsg: *|string, status: number}|any|undefined>}
     */
    async pageEorder(params) {
        return await this.callms("sve_order", "pageEorder", params);
    }


    /**
     * fn:查询商户下可用订单的产品
     * @param params
     * @returns {Promise<{msg: string, data, bizmsg: *|string, status: number}|any|undefined>}
     */
    async getMerchantLiveProduct(params){
        return await this.callms("sve_order", "getMerchantLiveProduct", params);
    }
}

module.exports = OrderService;
