const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class FeeService extends ServiceBase {
  constructor() {
    super();
    // 引擎不可以引用任何
  }

  /**
   * 账户查询
   * @param params
   * account_id: 账户id
   * @returns
   */
  async account(params) {
    try {
      return await this.callms("engine_fee", "accountInfo", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }


  /**
   * 创建计费账户
   * @param params
   * app_id: 电子签订单 100001
   * app_data_id: 订单id
   * balance: 余额，整数（分或份）
   * @returns {status:0, msg: "", data: {account_id: 1111}}
   */
  async createAccount(params) {
    try {
      return await this.callms("engine_fee", "accountCreate", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 账户查询
   * @param params
   * account_id: 账户id
   * @returns
   */
  async account(params) {
    try {
      return await this.callms("engine_fee", "accountInfo", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 账户查询批量
   * @param params
   * account_ids: 账户id
   * @returns
   */
  async accountBulk(params) {
    try {
      return await this.callms("engine_fee", "accountBulkInfo", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 账户查询批量
   * @param params
   * {
   *     "account_id": "1",
   *     "trade_amt": 57,
   *     "trade_no": "123314",
   *     "trade_desc": "三要素验证"
   * }
   * +
   * account_ids: 账户id
   * @returns
   */
  async accountTrade(params) {
    try {
      return await this.callms("engine_fee", "accountTrade", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * @param params
   * {
   *     "currentPage": 1,
   *     "pageSize": 10,
   *     "account_id": "1",
   *     "trade_type": "1",
   *     "trade_no": "123313",
   *     "tradeTimeBegin": "2020-06-26 04:21:31",
   *     "tradeTimeEnd": "2020-06-26 05:11:31"
   * }
   * @returns
   */
  async accountTradePage(params) {
    try {
      return await this.callms("engine_fee", "accountTrade", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * account_id
   * @param params
   * {
   *     "account_id": "1",
   *     "trade_type": "1",
   *     "trade_nos": ['1','2'],
   * }
   * @returns {Promise<{msg: string, data: (*|null), bizmsg: string, status: number}|{msg: string, data, bizmsg: *|string, status: number}|any|undefined>}
   */
  async tradeMapByIds(params) {
    try {
      return await this.callms("engine_fee", "tradeMapByIds", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async setRowsFee(rows, field) {
    if (!rows || rows.length == 0 || !field) {
      return;
    }
    let ids = [];
    for (let item of rows) {
      let id = Number(item[field] || 0);
      if (!id) {
        continue;
      }
      ids.push(id);
    }
    let map = await this.accountBulk({ids: ids});
    map = map.data || {};
    for (let item of rows) {
      item.fee = map[Number(item[field] || 0)] || {balance:0};
      item.allowance=Number(item.product_specifications) - Number(item.fee.balance || 0);
      item.allowance = item.allowance < 0 ? 0 : item.allowance;
    }
  }


}

module.exports = FeeService;