var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");
const md5 = require("MD5");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("web.common.oplogCtl");

class UserCtl extends CtlBase {
  constructor() {
    super();
    this.userSve = system.getObject("service.uc.userSve");
    this.redisClient = system.getObject("util.redisClient");
  }

  async login(pobj, pobj2, req, res) {
    var loginName = this.trim(pobj.loginName);
    var password = this.trim(pobj.password);
    try {
      let loginUser = await this.userSve.login({
        ucname: loginName,
        password: password,
        uctype: 2,
      });
      if (loginUser.status != 0) {
        return loginUser;
      }

      loginUser = loginUser.data;

      // TODO 查询商户名称
      let rs = this.loginDTO(loginUser)
      rs.key = await this.setLogin(loginUser);
      return system.getResultSuccess(rs);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

  async setLogin(user) {
    let loginsid = "e-mcht-" + uuidv4();
    if (settings.env = "dev") {
      loginsid = "e-mcht-" + user.id;
    }
    await this.redisClient.setWithEx(loginsid, JSON.stringify(user), 60 * 60 * 5);
    return loginsid;
  }

  async currentUser(qobj, pobj, req) {
    return system.getResultSuccess(this.loginDTO(req.loginUser));
  }

  loginDTO(user) {
    return {
      loginName: user.ucname,
      mobile: user.mobile,
      real_name: user.real_name,
    }
  }

  /**
   * 启用禁用
   * @param {*} params
   * @param {*} pobj2
   * @param {*} req
   */
  async enabled(params, pobj2, req) {
    try {
      params.id = Number(params.id || 0);
      params.enabled = Number(params.enabled || 0);
      return await this.userSve.enabled(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async resetPassword(params, pobj2, req) {
    try {
      let p = {
        id: req.loginUser.id,
        uctype_id: params.uctype_id,
        oldPassword: this.trim(params.oldPassword),
        newPassword: this.trim(params.newPassword),
        newPasswordConfirm: this.trim(params.newPasswordConfirm),
      };
      if (!p.newPassword) {
        return system.getResult(null, "修改密码失败，新密码不能为空");
      }
      if (p.newPassword != p.newPasswordConfirm) {
        return system.getResult(null, "修改密码失败，两次密码输入不一致");
      }
      return await this.userSve.resetPassword(p);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   *   查询明细
   * @param {*} params
   */
  async queryById(params, pobj2, req) {
    try {
      return await this.userSve.queryById(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async updPassword(params, pobj2, req) {
    params.password = this.trim(params.password);
    if (!params.password) {
      return system.getResult(null, `请填写密码`);
    }

    try {
      return await this.userSve.updPassword(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 根据pid查出子目录
   * @param {*} params
   */
  async page(params, pobj2, req) {
    try {
      params.uctypeId = params.deliver_id;
      return await this.userSve.page(params);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async salesmanList(params, pobj2, req) {
    try {
      if (!params.deliver_id) {
        return system.getResultSuccess([]);
      }
      return await this.userSve.salesmanList(params);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
}

module.exports = UserCtl;