var system = require("../../../system")
const CtlBase = require("../../ctlms.base");

class ProductCtl extends CtlBase {
  constructor() {
    super();
    this.prodSve = system.getObject("service.product.productSve");
  }

  async getPage (pobj, pobj2, req) {
    try {
      let res = await this.prodSve.getPage(pobj);
      return res
    } catch (error) {
      return system.getResultFail(500, err.message)
    }
  }

  async getAllDic (pobj, pobj2, req) {
    try {
      let res = await this.prodSve.getAllDic(pobj)
      return res
    } catch (error) {
      return system.getResultFail(500, err.message)
    }
  }

  async getByIds (pobj, pobj2, req) {
    try {
      let res = await this.prodSve.getByIds(pobj)
      return res
    } catch (error) {
      return system.getResultFail(500, err.message)
    }
  }

  async getItems (pobj, pobj2, req) {
    try {
      let res = await this.prodSve.getItems(pobj)
      return res
    } catch (error) {
      return system.getResultFail(500, err.message)
    }
  }

  async createOrUpdate (pobj, pobj2, req) {
    try {
      let res = await this.prodSve.createOrUpdate(pobj)
      return res
    } catch (error) {
      return system.getResultFail(500, err.message)
    }
  }

  async apiList (pobj) {
    try {
      let res = await this.prodSve.apiList(pobj)
      return res
    } catch (error) {
      return system.getResultFail(500, err.message)
    }
  }
  
  async apiMap (pobj) {
    try {
      let res = await this.prodSve.apiMap(pobj)
      return res
    } catch (error) {
      return system.getResultFail(500, err.message)
    }
  }
}

module.exports = ProductCtl;