var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");

class OrderCtl extends CtlBase {
    constructor() {
        super();
        this.userSve = system.getObject("service.uc.userSve");
        this.orderSve = system.getObject("service.order.orderSve");
        // this.redisClient = system.getObject("util.redisClient");
        this.productSve = system.getObject("service.product.productSve");
        this.ordersignlogSve = system.getObject("service.order.ordersignlogSve");
        this.orderauthlogSve = system.getObject("service.order.orderauthlogSve");
        this.feeSve = system.getObject("service.fee.feeSve");
    }

    /**
     * fn:查询商户下可用订单的产品(所有)
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<{msg: *, data, bizmsg: *|string, status: number}|*|{msg: string, data, bizmsg: (*|string), status: number}>}
     */
    async getMerchantLiveAllProducts(pobj, pobj2, req, res){
        if(!pobj.merchant_id){
            return system.getResult(null, `参数错误 商户ID不能为空`);
        }
        try{
            return await this.orderSve.getMerchantLiveAllProducts(pobj);
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }



    /**
     * fn:查看订单(根据ID查询)
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<{msg: string, data: (*|null), bizmsg: string, status: number}>}
     */
    async getEorderById(pobj, pobj2, req, res) {
        try{
            if(!pobj.id){
                return system.getResult(null, `订单【${pobj.id}】不存在`);
            }
            let res = await this.orderSve.getEorderById(pobj);
            if(res.status==0 && res.data.product_arr){
                for(let item of res.data.product_arr){
                    item.price = system.f2y(item.price);
                }
            }

            // 计费
            // let feeRes = await this.feeSve.setRowsFee([res.data], "engine_account_id");
            return res;
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }

    /**
     * fn:查看订单列表(分页)
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<{msg: string, data: (*|null), bizmsg: string, status: number}>}
     */
    async pageEorder(pobj, pobj2, req, res) {
        try{
            let res = await this.orderSve.pageEorder(pobj);
            if(res.status!=0 || res.data.count==0){
                return res;
            }
            //格式化产品信息
            let ids = [],productMap={};
            for (let item of res.data.rows) {
                item.price = system.f2y(item.price);
                if(item.product_type=='1'){
                    item.product_unit_price = system.f2y(item.product_unit_price);
                }
                if(item.product_type=='2'){
                    item.product_specifications = system.f2y(item.product_specifications);
                }
                ids.push(item.product_id);
            }
            let p_listRes = await this.productSve.getByIds({ids:ids});
            if(p_listRes.status!=0){
                return system.getResult(`获取订单产品失败`);
            }
            //将产品列表映射成Map结构
            for (let ele of p_listRes.data) {
                productMap[ele.id]=ele;
            }
            for (let item of res.data.rows) {
                item.product_info = productMap[item.product_id];
            }
            // 设置计费内容
            await this.feeSve.setRowsFee(res.data.rows, "engine_account_id");
            return res;
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }



    /**
     * fn:查询商户下可用订单的产品
     * @param pobj
     * @param pobj2
     * @param req
     * @param res
     * @returns {Promise<void>}
     */
    async getMerchantLiveProduct(pobj, pobj2, req, res){
        if(!pobj.merchant_id){
            return system.getResult(null, `参数错误 商户ID不能为空`);
        }
        try{
            return await this.orderSve.getMerchantLiveProduct(pobj);
        }catch (e) {
            console.log(e);
            return system.getResult(null, `系统错误`);
        }
    }

}

module.exports = OrderCtl;
