var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");
const md5 = require("MD5");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("web.common.oplogCtl");

class merchantCtl extends CtlBase {
    constructor() {
        super();
        this.merchantSve = system.getObject("service.merchant.merchantSve");
        this.userSve = system.getObject("service.uc.userSve");
    }


    async merchantOfInfo(params, pobj2, req) {
        try {
            params.id = req.body.merchant_id;
            let res = await this.merchantSve.merchantOfInfo(params);
            if (res.data) {
                await this.userSve.setRowsUser([res.data], "bd_id", "bd");
            }
            return res;
        } catch (error) {
            console.log(error);
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }


    async merchantToIdsInfo(params, pobj2, req){
        try {
            return await this.merchantSve.merchantToIdsInfo(params);
        } catch (error) {
            console.log(error);
            return system.getResult(null, `系统错误 错误信息 ${error}`);
        }
    }
}

module.exports = merchantCtl;
