const system = require("../system");
const uuidv4 = require('uuid/v4');
const DocBase = require("./doc.base");
const settings = require("../../config/settings");
class APIBase extends DocBase {
    constructor() {
        super();
        this.redisClient = system.getObject("util.redisClient");
        this.cacheManager = system.getObject("db.common.cacheManager");
        this.apitradeSvr = system.getObject("service.common.apitradeSve");
        this.logCtl = system.getObject("web.common.oplogCtl");
    }
    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    /**
     * 白名单验证
     * @param {*} gname 组名
     * @param {*} methodname 方法名
     */
    async isCheckWhiteList(gname, methodname) {
        var fullname = gname + "." + methodname;
        var lst = [
            "auth.getAccessKey",
            "meta.getBaseComp",
            "meta.doc",
            "meta.clearAllCache"
        ];
        var x = lst.indexOf(fullname);
        return x >= 0;
    }
    async checkAcck(gname, methodname, pobj, query, req) {
        var apptocheck = null;
        var isCheckWhite = await this.isCheckWhiteList(gname, methodname);
        if (!isCheckWhite) {//在验证请单里面,那么就检查访问token
            var ak = req.headers["accesskey"];
            try {
                apptocheck = await this.cacheManager["ApiAccessKeyCache"].cache(ak, null, null, null);
            } catch (e) {
                this.logCtl.error({
                    optitle: "获取访问token异常_error",
                    op: pobj.classname + "/" + methodname,
                    content: e.stack,
                    clientIp: pobj.clientIp
                });
            }
        }
        return { app: apptocheck, ispass: isCheckWhite || apptocheck };
    }
    async doexec(gname, methodname, pobj, query, req) {
        var requestid = req.headers["request-id"] || this.getUUID();
        try {
            //检查访问token
            var isPassResult = await this.checkAcck(gname, methodname, pobj, query, req);
            if (!isPassResult.ispass) {
                var tmpResult = system.getResultFail(system.tokenFail, "访问token失效，请重新获取");
                tmpResult.requestid = "";
                return tmpResult;
            }
            // //检查appkey
            // let key = await this.cacheManager["InitAppKeyCache"].getAppKeyVal(pobj.appKey);
            // if(key==null){
            //   return system.getResultFail(system.appKeyError,"appKey授权有误");
            // }
            req.app = isPassResult.app;
            var rtn = await this[methodname](pobj, query, req);
            if (isPassResult.app) {
                if (methodname && methodname.indexOf("apiAccessCount") < 0) {
                    this.apitradeSvr.create({
                        srcappkey: isPassResult.app.appkey,
                        tradeType: "consume",
                        op: req.classname + "/" + methodname,
                        params: JSON.stringify(pobj),
                        clientIp: req.clientIp,
                        agent: req.uagent + ";reqid=" + requestid,
                        destappkey: settings.appKey,
                    });
                }
            }
            rtn.requestid = requestid;
            return rtn;
        } catch (e) {
            console.log(e.stack, "api调用异常--error...................");
            this.logCtl.error({
                optitle: "api调用异常--error",
                op: req.classname + "/" + methodname + ";reqid=" + requestid,
                content: e.stack,
                clientIp: req.clientIp
            });
            var rtnerror = system.getResultFail(-200, "出现异常，请联系管理员");
            rtnerror.requestid = requestid;
            return rtnerror;
        }
    }
}
module.exports = APIBase;

