const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
class PushlogService extends ServiceBase {
  constructor() {
    super("common", ServiceBase.getDaoName(PushlogService));
    this.logCtl = system.getObject("service.common.oplogSve");
    this.pushfaillogDao = system.getObject("db.common.pushfaillogDao");
    this.gatewaypushlogDao = system.getObject("db.common.gatewaypushlogDao");
  }
  async createDb(qobj) {
    try {
      qobj.optitle = (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "：" + qobj.optitle;
      this.dao.create(qobj);
    } catch (e) {
      //日志记录
      this.logCtl.error({
        appid: qobj.appid || "",
        appkey: qobj.appkey || "",
        requestId: qobj.requestId || "",
        op: qobj.op || "",
        content: qobj.content + "-->error：" + e.stack,
        clientIp: qobj.clientIp || "",
        optitle: qobj.optitle || "" + "-->添加日志失败center_channel_pushlog->createDb",
      });
    }
  }
  async createFailLogDb(qobj) {
    try {
      qobj.opTitle = (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "：" + qobj.opTitle;
      this.pushfaillogDao.create(qobj);
    } catch (e) {
      //日志记录
      this.logCtl.error({
        appid: qobj.appid || "",
        appkey: qobj.appkey || "",
        requestId: qobj.requestId || "",
        op: qobj.op || "",
        content: qobj.content + "-->error：" + e.stack,
        clientIp: qobj.clientIp || "",
        optitle: qobj.optitle || "" + "-->添加日志失败center_channel_pushfaillog->createFailLogDb",
      });
    }
  }
  async delDbPushfaillogById(id) {
    this.pushfaillogDao.bulkDeleteByWhere({ where: { id: id } });
  }
  async getFailLogList() {
    var sql = "SELECT id,`content`,failType,pushNumber,opTitle FROM `center_channel_pushfaillog` WHERE failType IN(1,2,4) AND pushNumber<10 LIMIT 200";
    var list = await this.pushfaillogDao.customQuery(sql);
    var result = system.getResultSuccess(list);
    return result;
  }

  //获取channel推送失败记录
  async getPushFailLogList(actionBody) {
    var sql = "SELECT id,appid,`content`,failType,pushNumber,opTitle,resultInfo,created_at FROM `center_channel_pushfaillog` WHERE pushNumber=10 ";
    let whereParams = {};
    if(actionBody.appid){
      sql += " and appid = :appid";
      whereParams.appid = actionBody.appid;
    }
    if(actionBody.likeStr){
      sql += " and content like :likeStr";
      whereParams.likeStr = "%"+ actionBody.likeStr +"%";
    }
    sql += " order by created_at desc"
    var list = await this.pushfaillogDao.customQuery(sql,whereParams);
    var result = system.getResultSuccess(list);
    return result;
  }

  /**
   * channel重新推送
   * @param actionBody
   * @returns {Promise<void>}
   */
  async rePush(actionBody){
    let content = actionBody.content;
    let sql = 'update `center_channel_pushfaillog` set pushNumber = :pushNumber';
    let params = {
      pushNumber: actionBody.pushNumber || 9
    }
    if(Object.keys(content).length>0){
      sql += ',content=:content';
      params.content = JSON.stringify(actionBody.content);
    }
    sql += ' where id = :id';
    params.id = actionBody.id;
    let result = await this.customUpdate(sql,params);
    return system.getResult(result);
  }

  //获取Gateway推送失败记录
  async getGatewayPushFailLogList(actionBody) {
    var sql = "SELECT id,requestUrl,requestjson,pushUrl,pushActionType,pushtimes,pushStatus,created_at,error FROM `gateway_pushlog` WHERE pushtimes=4 and pushStatus='wts'";
    let whereParams = {};
    if(actionBody.likeParams){
      sql += " and requestjson like :likeParams";
      whereParams.likeParams = "%"+ actionBody.likeParams +"%";
    }
    if(actionBody.likeError){
      sql += " and error like :likeError";
      whereParams.likeError = "%"+ actionBody.likeError +"%";
    }
    sql += " order by created_at desc"
    var list = await this.gatewaypushlogDao.customQuery(sql,whereParams);
    var result = system.getResultSuccess(list);
    return result;
  }

  /**
   * Gateway重新推送
   * @param actionBody
   * @returns {Promise<void>}
   */
  async reGatewayPush(actionBody){
    let content = actionBody.content;
    let sql = 'update `gateway_pushlog` set pushtimes = :pushtimes';
    let params = {
      pushtimes: actionBody.pushNumber || 3
    }
    if(Object.keys(content).length>0){
      sql += ',requestjson=:content';
      params.content = JSON.stringify(actionBody.content);
    }
    sql += ' where id = :id';
    params.id = actionBody.id;
    let result = await this.customUpdate(sql,params);
    return system.getResult(result);
  }


  async addPublicServiceLog(pobj, req) {
    var sql = "INSERT INTO `igirl_api`.`center_channel_public_servicelog` (`appkey`,`pushUrl`,`pushContent`,`resultInfo`,`pushNumber`,`clientIp`,created_at)" +
      "VALUES(:appkey,:pushUrl,:pushContent,:resultInfo,:pushNumber,:clientIp,:created_at)";
    var params = {
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
      pushUrl: pobj.actionBody.pushUrl,
      pushContent: pobj.actionBody.pushContent ? JSON.stringify(pobj.actionBody.pushContent) : "",
      resultInfo: pobj.actionBody.resultInfo ? JSON.stringify(pobj.actionBody.resultInfo) : "",
      pushNumber: pobj.actionBody.pushNumber || 0,
      clientIp: req.clientIp || "",
      created_at: new Date()
    }
    await this.pushfaillogDao.customInsert(sql, params);
    return system.getResultSuccess();
  }
  async delPublicServiceLog(id) {
    var sql = "DELETE FROM `center_channel_public_servicelog`  WHERE id=:id";
    var params = {
      id: id
    }
    await this.pushfaillogDao.customDelete(sql, params);
    return system.getResultSuccess();
  }
  async getPublicServiceLogList() {
    var sql = "SELECT id,appkey,`pushUrl`,pushContent,pushNumber,clientIp FROM `center_channel_public_servicelog` WHERE pushNumber<10 LIMIT 10";
    var list = await this.pushfaillogDao.customQuery(sql);
    var result = system.getResultSuccess(list);
    return result;
  }
}
module.exports = PushlogService;
