var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class Ic extends APIBase {
    constructor() {
        super();
        this.centerorderSve = system.getObject("service.common.centerorderSve");
        this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    }

    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionProcess, pobj.actionType, pobj.actionBody, req);
        return result;
    }
    async opActionProcess(pobj, action_process, action_type, action_body, req) {
        var opResult = null;
        switch (action_type) {
            case "deliveryInfo"://办理公司表单数据
                break;
            case "deliveryStatus"://办理公司状态
                break;
            case "reqCenterOrderApi"://办理公司状态
                break;
            case "paySuccess"://支付回调
                opResult = await this.centerorderSve.paySuccess(pobj);
                break;
            case "orderClose"://阿里退款
                opResult = await this.utilsOrderSve.orderClose(pobj);
                break;
            case "pushOrderToDelivery":
                opResult= await this.centerorderSve.icOrderToDelievery(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = Ic;