const system = require("../../system");
const uuidv4 = require('uuid/v4');
const md5 = require("MD5");
var settings = require("../../../config/settings");

class OpPlatformUtils {
    constructor() {
        this.restClient = system.getObject("util.restClient");
        this.createUserUrl = settings.paasUrl() + "api/auth/accessAuth/register";
        this.fetchDefaultVCodeUrl = settings.paasUrl() + "api/auth/accessAuth/fetchDefaultVCode";
        this.loginUrl = settings.paasUrl() + "api/auth/accessAuth/loginByMd5Password";
        this.authByCodeUrl = settings.paasUrl() + "api/auth/accessAuth/authByCode";
        this.loginByVCodeUrl = settings.paasUrl() + "api/auth/accessAuth/loginByVCode";
        this.modiPasswordByMobileUrl = settings.paasUrl() + "api/auth/accessAuth/modiPasswordByMobile";

        this.exTime = 2 * 3600;//缓存过期时间，2小时
    }
    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    async getReqApiAccessKey(appKey, secret) {
        var cacheManager = system.getObject("db.common.cacheManager");
        var reqApiAccessKey = null;
        if (appKey && secret) {
            reqApiAccessKey = await cacheManager["ApiAccessKeyCache"].cache(appKey, null, this.exTime, secret);
        } else {
            reqApiAccessKey = await cacheManager["ApiAccessKeyCache"].cache(settings.appKey, null, this.exTime);
        }
        if (!reqApiAccessKey || !reqApiAccessKey.data) {
            return system.getResult(null, "获取请求token失败");
        }
        return reqApiAccessKey;
    }
    /**
     * 创建用户信息
     * @param {*} userName 用户名
     * @param {*} mobile 手机号
     * @param {*} password 密码，不传为使用默认密码
     * 
     * 返回值：
     * {
            "status": 0,---值为2000为已经存在此用户，注册失败
            "msg": "success",
            "data": {
                "auth_url": "http://sj.app.com:3002/auth?opencode=1e4949d1c39444a8b32f023143625b1d",---回调url，通过回调地址获取平台用户信息
                "opencode": "1e4949d1c39444a8b32f023143625b1d",---平台用户code随机生成会变，平台是30s有效期，通过其可以向获取用户信息
                "open_user_id": 12---平台用户id
            },
            "requestid": "5362bf6f941e4f92961a61068f05cd7f"
        }
     */
    async createUserInfo(userName, mobile, password, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        var param = {
            userName: userName,
            mobile: mobile,
            password: password || settings.defaultPassWord,

        }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.createUserUrl, reqApiAccessKey.data.accessKey);

        if (restResult.status != 0 || !restResult.data) {
            return system.getResult(restResult.status, restResult.msg);
        }
        return system.getResultSuccess(restResult.data);
    }
    async fetchVCode(mobile, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        var param = { mobile: mobile }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.fetchDefaultVCodeUrl, reqApiAccessKey.data.accessKey);

        if (restResult.status != 0 || !restResult.data) {
            return system.getResult(null, restResult.msg);
        }
        return system.getResultSuccess();
    }
    async modiPasswordByMobile(mobile, vcode, newPwd, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        var param = { mobile: mobile, vcode: vcode, newPwd: newPwd }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.modiPasswordByMobileUrl, reqApiAccessKey.data.accessKey);

        if (restResult.status != 0 || !restResult.data) {
            return system.getResult(null, restResult.msg);
        }
        return system.getResultSuccess();
    }
    /**
     * 用户登录
     * @param {*} userName 用户名
     * @param {*} password 密码，不传为使用默认密码
     * 
     * 返回值：
     * {
            "status": 0,---值为2010为用户名或密码错误
            "msg": "success",
            "data": {
                "auth_url": "http://sj.app.com:3002/auth?opencode=1e4949d1c39444a8b32f023143625b1d",---回调url，通过回调地址获取平台用户信息
                "opencode": "1e4949d1c39444a8b32f023143625b1d"---平台用户code随机生成会变，平台是30s有效期，通过其可以向获取用户信息
            },
            "requestid": "5362bf6f941e4f92961a61068f05cd7f"
        }
     */
    async login(userName, password, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        var param = {
            userName: userName,
            password: password || settings.defaultPassWord,

        }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.loginUrl, reqApiAccessKey.data.accessKey);

        if (restResult.status != 0 || !restResult.data) {
            return system.getResult(restResult.status, restResult.msg);
        }
        return system.getResultSuccess(restResult.data);
    }
    /**
     * 通过opencode获取用户登录信息
     * @param {*} opencode 用户登录或注册opencode
     * 
     * 返回值：
     * {
            "status": 0,---值为2010为用户名或密码错误
            "msg": "success",
            "data": {},---平台用户信息
            "requestid": "5362bf6f941e4f92961a61068f05cd7f"
        }
    */
    async authByCode(opencode, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        var param = {
            opencode: opencode
        }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.authByCodeUrl, reqApiAccessKey.data.accessKey);

        if (restResult.status != 0 || !restResult.data) {
            return system.getResult(restResult.status, restResult.msg);
        }
        return system.getResultSuccess(restResult.data);
    }
    /**
          * 创建用户信息
          * @param {*} userName 用户名
          * @param {*} mobile 手机号
          * @param {*} password 密码，不传为使用默认密码
          * 
          * 返回值：
          * {
                 "status": 0,---值为2000为已经存在此用户，注册失败
                 "msg": "success",
                 "data": {
                     "auth_url": "http://sj.app.com:3002/auth?opencode=1e4949d1c39444a8b32f023143625b1d",---回调url，通过回调地址获取平台用户信息
                     "opencode": "1e4949d1c39444a8b32f023143625b1d",---平台用户code随机生成会变，平台是30s有效期，通过其可以向获取用户信息
                     "open_user_id": 12---平台用户id
                 },
                 "requestid": "5362bf6f941e4f92961a61068f05cd7f"
             }
          */
    async loginByVCode(mobile, vcode, password, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        var param = {
            mobile: mobile,
            vcode: vcode,
            password: password || ""
        }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.loginByVCodeUrl, reqApiAccessKey.data.accessKey);
        return restResult;
    }
    //------------------------新的方式------------------------------------------------------------------------------------
    async getReqTokenByHosts(appHosts, tokenValue) {
        if (!appHosts) {
            return system.getResult(null, "appHosts can not be empty");
        }
        var cacheManager = system.getObject("db.common.cacheManager");
        var result = await cacheManager["AppTokenByHostsCache"].cache(tokenValue, appHosts, system.exTime);
        return result;
    }

    async getReqUserPinByChannelUserId(actionBody, userPinValue) {
        if (!actionBody.channelUserId) {
            return system.getResult(null, "actionBody.channelUserId can not be empty");
        }
        var cacheManager = system.getObject("db.common.cacheManager");
        var result = await cacheManager["AppUserPinByChannelUserId"].cache(userPinValue, actionBody, system.exTime);
        return result;
    }

    async getReqUserPinByLgoin(actionBody, userPinValue) {
        if (!actionBody.userName) {
            return system.getResult(null, "actionBody.userName can not be empty");
        }
        if (!actionBody.password) {
            return system.getResult(null, "actionBody.password can not be empty");
        }
        var cacheManager = system.getObject("db.common.cacheManager");
        var result = await cacheManager["AppUserPinByLoginPwdCache"].cache(userPinValue, actionBody, system.exTime);
        return result;
    }

    async getReqUserPinByLgoinVcode(actionBody, userPinValue, reqType) {
        if (!actionBody.mobile) {
            return system.getResult(null, "actionBody.mobile can not be empty");
        }
        if (!actionBody.vcode) {
            return system.getResult(null, "actionBody.vcode can not be empty");
        }
        if (reqType == "reg") {
            if (!actionBody.password) {
                return system.getResult(null, "actionBody.password can not be empty");
            }
        }
        var cacheManager = system.getObject("db.common.cacheManager");
        var result = await cacheManager["AppUserPinByLoginVcodeCache"].cache(userPinValue, actionBody, system.exTime);
        return result;
    }
    async getVerifyCodeByMoblie(actionBody) {
        if (!actionBody.mobile) {
            return system.getResult(null, "pobj.mobile can not be empty ！");
        }
        if (!actionBody.appInfo) {
            return system.getResult(null, "pobj.appInfo can not be empty ！");
        }
        var acckapp = await this.fetchVCode(actionBody.mobile, actionBody.appInfo.uappKey, actionBody.appInfo.appSecret);
        return acckapp;
    }
    async putUserPwdByMobile(actionBody) {
        if (!actionBody.mobile) {
            return system.getResult(null, "pobj.mobile can not be empty ！");
        }
        if (!actionBody.vcode) {
            return system.getResult(null, "pobj.vcode can not be empty ！");
        }
        if (!actionBody.newPwd) {
            return system.getResult(null, "pobj.newPwd can not be empty ！");
        }
        if (!actionBody.appInfo) {
            return system.getResult(null, "pobj.appInfo can not be empty ！");
        }
        var acckapp = await this.modiPasswordByMobile(actionBody.mobile, actionBody.vcode, actionBody.newPwd, actionBody.appInfo.uappKey, actionBody.appInfo.appSecret);
        if (acckapp.status == 0 && actionBody.userpin) {
            this.userLogout(actionBody);
        }
        return acckapp;
    }
    async userLogout(actionBody) {
        if (!actionBody.userpin) {
            return system.getResult(null, "pobj.userpin can not be empty ！");
        }
        var cacheManager = system.getObject("db.common.cacheManager");
        await cacheManager["AppUserPinByLoginVcodeCache"].invalidate(actionBody.userpin);
        await cacheManager["AppUserPinByLoginPwdCache"].invalidate(actionBody.userpin);
        return system.getResultSuccess();
    }
}

module.exports = OpPlatformUtils;
